@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Doktorlar ve Personeller</h1>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 10%;"> Resim</th>
                    <th style="width: 30%;"> Ünvan</th>
                    <th style="width: 20%;"> Ad Soyad</th>
                    <th style="width: 35%;"> İşlemler</th>
                </tr>
                </thead>
                <tbody id="pagelist">
                @if (count($medical_staffs) > 0 )
                    @foreach($medical_staffs as $medical_staff)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td><img src="{{ $medical_staff->image }}" class="img-fluid" width="125" /></td>
                            <td>{{ @$medical_staff->medicalStaffDetail[0]->position }}</td>
                            <td>{{ $medical_staff->name . ' ' . $medical_staff->surname }}</td>
                            <td>
                                <a href="{{ route('adtrpanel.kadromuz.delete', $medical_staff->medical_staff_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.kadromuz.edit', $medical_staff->medical_staff_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="4" style="text-align: right;">Seçilileri &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">Seçiniz</option>
                                <option value="sil">Sil</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">
                            {{ $medical_staffs->appends(['aranan' => old('aranan')])->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">Hiçbir sayfa bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#medicalstaff"]').attr('aria-expanded', 'true');
            $('#medicalstaff').addClass('show')
        });
    </script>
@endsection