@extends('adtrpanel.layouts.master')
@section('title','Email Yönetimi')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">

        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('admin.email_management') }}</h1>
        <!--İletişim Talepleri-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 3%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 22%;"> {{ trans('admin.emails') }}</th>
                    <th style="width: 22%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="sliderlist">
                @if (count($emails) > 0 )
                    @foreach($emails as $email)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td> {{ $email->email }} </td>

                            <td>
                                <a href="{{ route('adtrpanel.emails.delete', $email->id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.emails.json') }}">
                                    <button class="btn btn-warning btn-sm">
                                        <i class="fa fa-times"></i> JSON Çıktı
                                    </button>
                                </a>

                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td  style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td colspan="2">
                            <select name="islem" onchange="this.form.submit()">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">{{ trans('Hiç bir mail bulunamadı') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#mails"]').attr('aria-expanded', 'true');
            $('#mails').addClass('show')
        });
    </script>

@endsection