<!doctype html>
<html lang="{{ config('app.locale') }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="apple-touch-icon" href="favicon.ico">
    <link href="https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700,900&amp;subset=latin-ext" rel="stylesheet">
    <title>Giriş yap</title>
    <!-- Bootstrap core CSS -->
    <link href="/admin/css/bootstrap.min.css" rel="stylesheet">
    <link href="/admin/css/login.css" rel="stylesheet">
</head>

<body class="b-login text-center">
<form class="form-signin" action="{{ route('adtrpanel.login') }}" method="post">
    {{ csrf_field() }}
    @include('adtrpanel.partials.errors')
    <img class="mb-4" src="/admin/img/header/adtlogo.svg" alt="Adtorium" width="270">
    <h1 class="h3 mb-3 font-weight-normal">Lütfen giriş yapın</h1>
    <label for="inputEmail" class="sr-only">E-posta adresiniz</label>
    <input type="email" name="email" id="inputEmail" class="form-control" required autofocus>
    <label for="inputPassword" class="sr-only">Parolanız</label>
    <input type="password" name="password" id="inputPassword" class="form-control" required>
    <div class="checkbox mb-3">
        <label>
            <input type="checkbox" value="remember-me"> Beni Hatırla
        </label>
    </div>
    <button class="btn btn-lg btn-primary btn-block" type="submit">Giriş yap</button>
    <p class="mt-5 mb-3 login-copyright">&copy; Adtorium 2018</p>
</form>
</body>
<script src="/admin/js/jquery-3.3.0.min.js"></script>
<script src="/admin/js/jquery.backstretch.min.js"></script>
<script>
    $(document).ready(function () {
        $.backstretch([
            "/admin/img/login/1.jpg",
            "/admin/img/login/2.jpg",
            "/admin/img/login/3.jpg",
            "/admin/img/login/4.jpg",
            "/admin/img/login/5.jpg"
        ], {duration: 3000, fade: 750});
    })
</script>
</html>
