@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('admin.language_add') }}</h1>
        <form @if(isset($language)) action="{{route('adtrpanel.language.save',$language->language_id)}}" @else action="{{route('adtrpanel.language.save')}}" @endif method="post" enctype="multipart/form-data" autocomplete="off">
            <div class="table-responsive">
                <section class="page-content" xmlns="http://www.w3.org/1999/html">

                        {!! csrf_field() !!}
                        <div class="text-right">
                            <div class="actions btn-set">
                                <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                                <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                            </div>
                        </div>
                        <hr>
                        <!--Masaüstü Sekme Linkleri-->
                        <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                            <ul class="nav nav-tabs product-tabs-select">
                                <li class="nav-item">
                                    <a class="nav-link active" data-toggle="pill" href="#general_info">{{trans("admin.language_info")}}</a>
                                </li>
                            </ul>
                        </div>
                        <!--Masaüstü Sekme Linkleri Bitti-->

                        <!--Mobil Sekme Linkleri-->
                        <div class="d-lg-none d-sm-block tabs-mobile">
                            <select title="Sekme seçiniz" class="mobile-select">
                                <option data-toggle="pill" value="#general_info">{{trans("admin.language_info")}}</option>
                            </select>
                        </div>
                        <!--Mobil Sekme Linkleri Bitti-->
                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div class="tab-pane active" id="general_info">
                                <!--Genel Bilgiler-->
                                <div class="form-group row">
                                    <label for="soru" class="col-sm-2 col-form-label">{{trans("admin.language_details")}} <span class="required-input">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" name="language_details" maxlength="100" placeholder="{{trans("admin.language_details")}}" value="{{ @$language->language_details}}" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="cevap" class="col-sm-2 col-form-label">{{trans("admin.language_short_name")}} <span class="required-input">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" name="language_short_name" maxlength="10" placeholder="{{trans("admin.language_short_name")}}" value="{{ @$language->language_short_name}}" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="language_image" class="col-sm-2 col-form-label">{{trans("admin.language_image")}} <span class="required-input">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="file" accept="image/jpeg, image/png"  class="form-control" name="language_image" >
                                    </div>
                                </div>
                                <div class="from-group row">
                                    @if(isset($language))
                                        <img src="{{ $language->language_image }}" class="img-fluid">
                                    @endif
                                </div>
                                <!-- Genel Bilgi Bitti -->
                            </div>
                        </div>
                    </form>
                </section>
            </div>

    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#language"]').attr('aria-expanded', 'true');
            $('#language').addClass('show')
        });
    </script>
@endsection