@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include("adtrpanel.partials.alert")
        <div class="text-right">
            <a href="{{route('adtrpanel.language.languageForm')}}" class="btn btn-success">Dil Ekle</a>
        </div>
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('admin.languages') }}</h1>
        <form action="" method="post">
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th style="width: 5%;" class="text-center">
                            <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                <span></span>
                            </label>
                        </th>
                        <th style="width: 25%;"> {{ trans('admin.language_details') }}</th>
                        <th style="width: 20%;"> {{ trans('admin.language_image') }}</th>
                        <th style="width: 30%;"> {{ trans('admin.language_short_name') }}</th>
                        <th style="width: 20%;"> {{ trans('admin.actions') }}</th>
                    </tr>
                    </thead>
                    <tbody id="commentlist">
                    @foreach($languages as $language)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                </label>
                            </td>
                            <td>{{$language->language_details}}</td>
                            <td>
                                <img class="img-thumbnail" src="{{$language->language_image}}" alt="">
                            </td>
                            <td>
                                <h5><span class="badge badge-info">{{$language->language_short_name}}</span></h5>
                                @if($language->language_default == 1)
                                    <h5><span class="badge badge-success">Varsayılan</span></h5>
                                @endif
                            </td>
                            <td>
                                <a href="{{route('adtrpanel.language.setDefault', $language->language_id)}}"
                                   class="btn btn-warning btn-sm">Varsayılan Yap</a>
                                <a href="{{route('adtrpanel.language.languageForm',$language->language_id)}}"
                                   class="btn btn-success btn-sm">Düzenle</a>
                                <a href="{{route('adtrpanel.language.delete', $language->language_id)}}"
                                   class="btn btn-danger btn-sm">Sil</a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                    <tfoot>
                    <tr>
                        <td colspan="4" class="text-right">Seçilenleri</td>
                        <td class="text-right">
                            <select name="bulkProcess" class="form-control">
                                <option selected hidden>Seçiniz</option>
                                <option value="deleteAll">Sil</option>
                            </select>
                        </td>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#language"]').attr('aria-expanded', 'true');
            $('#comments').addClass('show')
        });
    </script>
@endsection