@extends('adtrpanel.layouts.master')
@section('title','Fotograflar')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('admin.photos') }}</h1>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 15%;"> {{ trans('Resim') }}</th>
                    <th style="width: 25%;"> {{ trans('Resim Adı') }}</th>
                    <th style="width: 15%;"> {{ trans('admin.in_video_gallery_name') }}</th>
                    <th style="width: 10%;"> {{ trans('admin.status') }}</th>
                    <th style="width: 30%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="videolist">
                @if ($photos->count() > 0 )
                    @foreach($photos as $photo)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td><img src="/{{$photo->photo_image}}" class="img-fluid" width="150" /></td>
                            <td>{{$photo->photo_name}}</td>
                            <td>{{$photo->galeri->gallery_name }}</td>
                            <td>
                                @if($photo->status)
                                    <span class="badge badge-success">{{ trans('admin.active') }}</span>
                                @else
                                    <span class="badge badge-danger">{{ trans('admin.passive') }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.imagegallery.photos.delete', $photo->photo_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.imagegallery.photos.edit', $photo->photo_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                @if($photo->status)
                                    <a href="{{ route('adtrpanel.imagegallery.photos.deactivated', $photo->photo_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> {{ trans('admin.deactivated') }}
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.imagegallery.photos.activated', $photo->photo_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> {{ trans('admin.activated') }}
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="5" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="6">
                            {!! $photos->appends(['aranan' => old('aranan')])->links() !!}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="6">{{ trans('admin.no_videos_found') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#imagegallery"]').attr('aria-expanded', 'true');
            $('#imagegallery').addClass('show')
        });
    </script>
@endsection