@extends('adtrpanel.layouts.master')
@section('title','Fotograf Ekle')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post"
              action="@if(isset($photos)) {{ route('adtrpanel.imagegallery.photos.save', $photos[0]->photo_id) }} @else {{ route('adtrpanel.imagegallery.photos.save') }} @endif"
              enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i
                                    class="fa fa-angle-left"></i> Geri
                        </button>
                    </a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i>
                        Kaydet
                    </button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">Genel Bilgiler</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">Genel Bilgiler</option>

                </select>
            </div>
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @section('css')
                                <style>
                                    .active {
                                        display: block !important;
                                    }
                                </style>
                                <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css"
                                      rel="stylesheet"/>
                            @endsection
                            @section('js')
                                <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
                            @endsection
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}"
                                       data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block"
                                             src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px"
                                           class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <!--Genel Bilgiler-->
                    @php $a = 0; @endphp
                    @foreach($languages as $language)
                        @php
                            @$photoX = \App\Models\PhotoDetail::where('language_id',$language->language_id)->where('photo_id',$photos[0]->photo_id)->first()
                        @endphp
                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}"
                             style="display: none;" id="{{$language->language_short_name}}">
                            <div class="form-group row">
                                <label for="photo_name" class="col-sm-2 col-form-label">Fotoğraf Adı <span
                                            class="-input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea"
                                           name="photo_name[{{$language->language_short_name}}]" maxlength="100"
                                           data-length=100 id="photo_name" placeholder="Fotoğraf Adı"
                                           @if(isset($photos)) value="{{  @$photoX->photo_name }}" @endif />
                                    <span class="char-count">150 </span> <span class="char-count-label">/ 150</span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="photo_image" class="col-sm-2 col-form-label">Fotoğraf </label>
                                <div class="col-sm-10">
                                    <input type="file" class="form-control char-textarea"
                                           name="photo_image[{{$language->language_short_name}}]" id="photo_image"/>
                                    @if(isset($photos)) <img src="/{{ @$photoX->photo_image }}" class="img-fluid"
                                                             width="150"/> @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="video_description" class="col-sm-2 col-form-label">Resim Açıklaması</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control"
                                              name="photo_description[{{$language->language_short_name}}]"
                                              id="photo_description" rows="5"
                                              placeholder="Resmin Açıklaması">@if(isset($photos)) {{@$photoX->photo_description}} @endif</textarea>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="status" class="col-sm-2 col-form-label">Durum</label>
                                <div class="col-sm-6">
                                    <select id="status" class="form-control" name="status[{{$language->language_short_name}}]">
                                        <option value="0"
                                                @if(isset($photos) && @$photoX->status == 0) selected="selected" @endif>Pasif
                                        </option>
                                        <option value="1"
                                                @if(isset($photos) && @$photoX->status == 1) selected="selected" @endif>Aktif
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="in_gallery[{{$language->language_short_name}}]" class="col-sm-2 col-form-label">Galeride Göster</label>
                                <div class="col-sm-6">
                                    <select id="in_gallery" class="form-control" name="in_gallery[{{$language->language_short_name}}]">
                                        <option value="0"
                                                @if(isset($photos) && @$photoX->in_gallery == 0) selected="selected" @endif>Hayır
                                        </option>
                                        <option value="1"
                                                @if(isset($photos) && @$photoX->in_gallery == 1) selected="selected" @endif>Evet
                                        </option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="video_category" class="col-sm-2 col-form-label">Fotoğraf Galerisi <span
                                            class="-input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <select class="js-example-basic-single" name="gallery[{{$language->language_short_name}}]">
                                        @foreach($photoGalleries as $photoGallery)
                                            @if($photoGallery->language_id == $language->language_id)
                                            <option value="{{$photoGallery->photo_gallery_id}}">{{$photoGallery->gallery_name}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>


                            @if(isset($photos))
                                <div class="form-group row">
                                    <label for="slug" class="col-sm-2 col-form-label">Büyük Foto Kısa Kodu
                                        <i class="fas fa-question-circle info-circle" data-html="true"
                                           data-toggle="tooltip" data-placement="right"
                                           title="Videoyu kendi oluşturacağınız sayfalarda büyük tipte kullanabilmeniz için gereken kod parçacığıdır.."></i>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control"
                                               value="[photo-id={{@$photoX->photo_id}},1]" readonly/>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="slug" class="col-sm-2 col-form-label">Küçük Fotoğraf Kısa Kodu
                                        <i class="fas fa-question-circle info-circle" data-html="true"
                                           data-toggle="tooltip" data-placement="right"
                                           title="Fotoğrafı kendi oluşturacağınız sayfalarda küçük tipte kullanabilmeniz için gereken kod parçacığıdır.."></i>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control"
                                               value="[photo-id={{@$photoX->photo_id}},2]" readonly/>
                                    </div>
                                </div>
                            @endif
                        </div>

                    @endforeach
                <!--Genel Bilgi Bittiker-->
                </div>
                </div>
        </form>
    </section>
@endsection
@section('css')
@endsection
@section('js')
    <script>
        $(document).ready(function () {
            $('*[data-target="#imagegallery"]').attr('aria-expanded', 'true');
            $('#imagegallery').addClass('show')
        });
    </script>
    <script src="/admin/js/plupload.full.min.js" type="text/javascript"></script>
    <script>
        // Custom example logic
        $(document).ready(function () {
            var uploader = new plupload.Uploader({
                runtimes: 'html5,flash,silverlight,html4',
                browse_button: 'pickfiles', // you can pass an id...
                container: document.getElementById('container'), // ... or DOM Element itself
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                url: '{{ route('adtrpanel.galeriresmiekle') }}',
                flash_swf_url: '/admin/js/Moxie.swf',
                silverlight_xap_url: '/admin/js/Moxie.xap',
                filters: {
                    max_file_size: '20mb',
                    mime_types: [
                        {title: "Image files", extensions: "jpg,png,jpeg"}
                    ]
                },
                init: {
                    PostInit: function () {
                        document.getElementById('filelist').innerHTML = '';
                        document.getElementById('uploadfiles').onclick = function () {
                            uploader.start();
                            return false;
                        };
                    },
                    FilesAdded: function (up, files) {
                        plupload.each(files, function (file) {
                            document.getElementById('filelist').innerHTML += '<div id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b></div>';
                        });
                    },
                    UploadProgress: function (up, file) {
                        document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
                    },
                    FileUploaded: function (up, file, result) {
                        document.getElementById('imagelisttable').innerHTML += result.response;
                    },
                    Error: function (up, err) {
                        document.getElementById('console').appendChild(document.createTextNode("\nError #" + err.code + ": " + err.message));
                    }
                }
            });
            uploader.init();
        });
    </script>
    <script>
        $(function () {
            var scntDiv = $('#imagelist');
            $(scntDiv).on('click', '#resimkaldir', function () {
                var tr_id = $(this).parents('tr').attr('id');
                $.ajax({
                    type: "post",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('adtrpanel.galeriresmisil') }}",
                    data: {"image_id": tr_id},
                    dataType: "text",
                    success: function (cevap) {
                        $('[data-id=resim' + tr_id + ']').remove();
                    }
                });
                return false;
            });
        });
    </script>
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#videogallery"]').attr('aria-expanded', 'true');
            $('#videogallery').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        config = {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        };
        @foreach($languages as $language)
        CKEDITOR.replace('video_description[{{$language->language_short_name}}]', config);
        @endforeach
    </script>
@endsection