@if(!empty($operations) && count($operations) > 0 )
    @php
        $tl = 0;
        $euro = 0;
        $usd = 0;
    @endphp
    @foreach($operations as $operation)
        <tr>
            <td>{{ $operation->subject }}</td>
            <td>{{ $operation->steps }}</td>
            <td>{{ $operation->operator }}</td>
            <td>{{ \Carbon\Carbon::parse($operation->operation_date)->format('d-m-Y H:i:s') }}</td>
            <td>{{ number_format($operation->price,2,',','') }}{{ $operation->current }}</td>
            <td>{{ $operation->note }}</td>
            <td>

                <button type="button" onclick="confirmDelete({{ $operation->pao_id }},{{ $operation->patient_id }})"
                        class="btn btn-sm btn-danger">
                    <i class="fa fa-trash"></i>
                </button>

            </td>
        </tr>
        @php
            if ($operation->current == "TL"){
            $tl += $operation->price;
            } elseif ($operation->current == "EURO"){
            $euro += $operation->price;
            } elseif ($operation->current == "USD"){
            $usd += $operation->price;
            }
        @endphp
    @endforeach
    <tr>
        <td colspan="4"></td>
        <td>
            Toplam <strong>{{ number_format($tl,2,',','') }} TL<br></strong>
            Toplam <strong>{{ number_format($euro,2,',','') }} EURO<br></strong>
            Toplam <strong>{{ number_format($usd,2,',','') }} USD<br></strong>

        </td>
        <td colspan="2"></td>
    </tr>
@else
    <tr>
        <td colspan="7" class="text-center">Kayıt Bulunmadı...</td>
    </tr>

@endif
