@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">

        <div class="col-12">
            <div class="row">
                <div class="col-6">
                    <h1 class="inner-page-title d-none d-sm-none d-lg-block">Hasta Takip Sistemi</h1>
                </div>
                <div class="col-6 text-right">
                    <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#newPatient">
                        Yeni Kayıt Ekle
                    </button>
                </div>
            </div>
        </div>
        <div style="background-color: #eeeeee;padding-top:10px;padding-left:15px;padding-right:15px;padding-bottom:15px;border-radius: 3px;border:1px solid #b6b6b6;"
             class="col-md-12 mb-5">
            <span style="line-height: 35px;font-size: 14px;margin-bottom: 10px;font-weight: bold;">Filtreler :</span>
            <form action="post" id="table-filter" onsubmit="return false;">
                <div class="form-group">
                    <input type="text" name="aranan" id="aranan" onkeyup="hastaAra();" class="form-control"
                           placeholder="Hasta Adı"
                           @if(request()->has('aranan'))
                           value="{{ request('aranan') }}"
                           @elseif(!empty(old('aranan')))
                           value="{{ old('aranan') }}"
                           @endif
                           >

                </div>


            </form>
        </div>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 15%;">Ad Soyad</th>
                    <th style="width: 15%;">Telefon</th>
                    <th style="width: 10%;">Toplam İşlem</th>
                    <th style="width: 50%;">İşlem Notu</th>
                    <th style="width: 10%;">İşlemler</th>
                </tr>
                </thead>
                <tbody id="pagelist">
                @if(!empty($patients) && count($patients) > 0)
                    @foreach($patients as $patient)
                        <tr id="patient_row_{{ $patient->patient_id }}">
                            <td>{{ $patient->name }}</td>
                            <td>{{ $patient->phone }}</td>
                            <td>{{ count($patient->operations) }}</td>
                            <td>{{ $patient->patients_note }}</td>
                            <td>
                                <button type="button" onclick="confirmDelete({{ $patient->patient_id }},0)"
                                        class="btn btn-sm btn-danger">
                                    <i class="fa fa-trash"></i>
                                </button>

                                <a href="{{ route('adtrpanel.hasta-takip.show',$patient->patient_id) }}"
                                   class="btn btn-sm btn-success">
                                    <i class="fa fa-edit"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="4" class="text-center">
                            {{ $patients->setPath(route('adtrpanel.hasta-takip'))->appends(['aranan' => old('aranan')])->links() }}
                        </td>
                    </tr>
                @else
                    <tr>
                        <td colspan="4" class="text-center">
                            Kayıt Bulunamadı.
                        </td>
                    </tr>
                @endif

                </tbody>
            </table>
        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
    <div class="modal fade" id="newPatient" tabindex="-1" role="dialog" aria-labelledby="newPatient" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="post" name="newpatient" id="new-patient">
                <div class="modal-content">

                    <div class="modal-body">

                        @csrf
                        <div class="form-group text-center">
                            <h3>Hasta Bilgileri</h3>
                        </div>
                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Hasta Ad Soyad:
                            </label>
                            <div class="col-sm-8">
                                <input type="text" required name="name" placeholder="Ad Soyad" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="phone" class="col-sm-4 col-form-label">Hasta Telefon :
                            </label>
                            <div class="col-sm-8">
                                <input type="text" required max="20" name="phone" placeholder="Telefon"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="note" class="col-sm-4 col-form-label">Hasta Notu :
                            </label>
                            <div class="col-sm-8">
                                <textarea class="form-control"
                                          placeholder="Hasta ile ilgili not düşmek isterseniz bu alana yazabilirsiniz."
                                          name="note"></textarea>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" id="mysavebtn" onclick="newPatient()" class="btn btn-primary">Hasta Ekle
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('css')
@endsection
@section('js')
    <script type="text/javascript">
        function hastaAra() {
            var data = $('#table-filter').serialize();

            //if (aranan != '' ) {

            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.hasta-ara') }}",
                data: data,
                dataType: "json",
                cache: false,
                success: function (response) {
                    if (response.html) {
                        $('#pagelist').html(response.html);
                    }

                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText)
                }
            });
            //}
        }
    </script>
    <script>

        function newPatient() {
            var form = $('#new-patient').serialize();
            $('#mysavebtn').attr('disabled', 'disabled');
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.hasta-takip.yeni-hasta') }}",
                data: form,
                dataType: "json",
                cache: false,
                success: function (response) {

                    if (response.result == 'success') {

                        $('#mysavebtn').removeAttr('disabled', 'disabled');
                        window.location = response.redirect_url;
                    } else {
                        $('#mysavebtn').removeAttr('disabled', 'disabled');
                        Swal.fire({
                            position: 'top',
                            type: 'error',
                            title: 'Ad Soyad ve Telefon Giriniz.',
                            showConfirmButton: false,
                            timer: 1500
                        })
                    }

                },
                error: function (xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
        }


        function confirmDelete(id, pid) {
            Swal.fire({
                title: 'Hastayı Silmek Üzerisiniz.',
                text: "Hastayı Silmek İstediğinize Eminmisiniz?",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet Sil',
                cancelButtonText: 'İptal'
            }).then((result) => {
                $.ajax({
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('adtrpanel.hasta-takip.delete') }}",
                    data: {'id': id, 'type': 'patient', 'pid': pid},
                    dataType: "json",
                    cache: false,
                    success: function (response) {

                        if (response.result == 'success') {
                            $('#patient_row_' + response.id).remove();
                        }

                    },
                    error: function (xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });
            })

        }
    </script>
@endsection