@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post">
            {{ csrf_field() }}

            <input type="hidden" name="language_id" value="{{ request()->segment('5') }}">

            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#group_info">Genel Bilgiler</a>
                    </li>

                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#group_info">Genel Bilgiler</option>

                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="group_info">
                    <!--Genel Bilgiler-->
                    <div class="col-7">
                        <form method="post">
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Hasta Ad Soyad:
                                </label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" value="{{ $patient->name }}" disabled
                                           class="form-control">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Hasta Telefon :
                                </label>
                                <div class="col-sm-8">
                                    <input type="text" value="{{ $patient->phone }}" disabled name="phone"
                                           class="form-control">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Hasta Notu :
                                </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note">{{ $patient->patients_note }}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">

                                <div class="col-sm-8">
                                    <button class="btn btn-primary" type="submit">Kaydet</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </form>
        <hr>
        <div class="row">
            <div class="col-6"><h2>Hasta Kaydı</h2></div>
            <div class="col-6 text-right">
                <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#add-operation">
                    Yeni Kayıt Ekle
                </button>
            </div>
        </div>
        <div class="table-responsive">

            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 10%;">Uygulama Konusu</th>
                    <th style="width: 20%;">Uygulama Durumu / Adımı</th>
                    <th style="width: 10%;">Uygulama Yetkilisi</th>
                    <th style="width: 10%;">Uygulama Tarihi</th>
                    <th style="width: 10%;">Uygulama Ücreti</th>
                    <th style="width: 10%;">Uygulama Notu</th>
                    <th style="width: 10%;">İşlemler</th>
                </tr>
                </thead>
                <tbody id="operation_list">
                @include('adtrpanel.hasta-takip.operation_row',[ 'operations' => $patient->operations])
                </tbody>
            </table>
        </div>
    </section>

    <div class="modal fade" id="add-operation" tabindex="-1" role="dialog" aria-labelledby="add-operation"
         aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <form method="post" name="new_operation" id="new_operation">
                <div class="modal-content">

                    <div class="modal-body">
                        <input type="hidden" name="patient_id" value="{{ $patient->patient_id }}">
                        @csrf
                        <div class="form-group text-center">
                            <h3>Uygulama Bilgileri</h3>
                        </div>
                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Uygulama Türü/Konusu :
                            </label>
                            <div class="col-sm-8">
                                <input type="text" required name="subject" placeholder="Uygulama Türü/Konusu"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="phone" class="col-sm-4 col-form-label">Uygulama Durumu / Adımı :
                            </label>
                            <div class="col-sm-8">
                                <input type="text" required max="200" name="step"
                                       placeholder="Uygulamanın durumu ile ilgili bilgiler"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="phone" class="col-sm-4 col-form-label">Uygulama Sorumlusu :
                            </label>
                            <div class="col-sm-8">
                                <input type="text" required max="200" name="operator"
                                       placeholder="Uygulamanın durumu ile ilgili bilgiler"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="phone" class="col-sm-4 col-form-label">Uygulama Tarihi :
                            </label>
                            <div class="col-sm-8">
                                <input type="datetime-local" required name="operation_date"
                                       placeholder="Operasyon Tatihi"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="phone" class="col-sm-4 col-form-label">Uygulama Ücreti :
                            </label>
                            <div class="col-sm-4">
                                <input type="number" required max="200" name="price" step="0.01" class="form-control">
                            </div>
                            <div class="col-sm-4">
                                <select name="current">
                                    <option value="TL">TL</option>
                                    <option value="USD">USD</option>
                                    <option value="EURO">EURO</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="note" class="col-sm-4 col-form-label">Uygulama Notu :
                            </label>
                            <div class="col-sm-8">
                                <textarea class="form-control"
                                          placeholder="Uygulama Notu"
                                          name="note"></textarea>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="reset" class="btn btn-info">
                            Temizle
                        </button>
                        <button type="button" id="mysavebtn" onclick="newOperation()" class="btn btn-primary">
                            Uygulama Ekle
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#patient"]').attr('aria-expanded', 'true');
            $('#patient').addClass('show')
        });
    </script>

    <script>

        function newOperation() {
            var form = $('#new_operation').serialize();
            $('#mysavebtn').attr('disabled', 'disabled');
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.hasta-takip.yeni-operasyon') }}",
                data: form,
                dataType: "json",
                cache: false,
                success: function (response) {
                    $('#mysavebtn').removeAttr('disabled');
                    if (response.result == 'success') {
                        $('#operation_list').html(response.html);
                    }

                },
                error: function (xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
        }

        function confirmDelete(id, pid) {
            Swal.fire({
                title: 'Uygulama/Operasyonu Silmek Üzerisiniz.',
                text: "Uygulama/Operasyonu silmek istediğinize eminmisiniz?",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet Sil',
                cancelButtonText: 'İptal',
            }).then((result) => {
                $.ajax({
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('adtrpanel.hasta-takip.delete') }}",
                    data: {'id': id, 'type': 'operation', 'pid': pid},
                    dataType: "json",
                    cache: false,
                    success: function (response) {
                        if (response.result == 'success') {
                            $('#operation_list').html(response.html);
                        }

                    },
                    error: function (xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });
            })

        }
    </script>
@endsection