@extends('adtrpanel.layouts.master')
@section('title','İnsan Kaynakları')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('İnsan Kaynakları CV') }}</h1>
        <!--İletişim Talepleri-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 3%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 50%;"> {{ trans('Adı - Soyadı') }}</th>
                    <th style="width: 50%;"> </th>
                </tr>
                </thead>
                <tbody id="sliderlist">
                @if (count($persons) > 0 )
                    @foreach($persons as $person)

                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{ $person['cv']->adi }} </td>
                            <td>
                                <a href="{{ route('adtrpanel.human.delete', $person['id']) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.human.show', $person['id']) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-eye"></i> CV Görüntüle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="2" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">

                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">{{ trans('Cv Eklenmemiş') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#human"]').attr('aria-expanded', 'true');
            $('#human').addClass('show')
        });
    </script>

@endsection