@extends('adtrpanel.layouts.master')
@section('title','İletisim Talepleri')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('admin.contact_form') }}</h1>
        <!--İletişim Talepleri-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 3%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 22%;"> {{ trans('admin.name') }}</th>
                    <th style="width: 22%;display: none"> {{ trans('admin.surname') }}</th>
                    <th style="width: 22%;"> {{ trans('admin.email') }}</th>
                    <th style="width: 10%;display: none"> {{ trans('admin.phone') }}</th>
                    <th style="width: 24%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="sliderlist">
                @if (count($contacts) > 0 )
                    @foreach($contacts as $contact)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td> {{ $contact->name }} </td>
                            <td style="display: none">{{ $contact->surname }}</td>
                            <td>{{ $contact->email }}</td>
                            <td style="display: none">
                               {{ $contact->phone }}
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.contact.delete', $contact->contact_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="#" data-toggle="modal" data-target="#modal_goruntule{{ $contact->contact_id  }}">
                                    <button class="btn btn-info btn-sm">
                                        <i class="fa fa-eye"></i> Mesajı Görüntüle
                                    </button>
                                </a>
                                <!-- modal-->
                                <div class="modal" id="modal_goruntule{{ $contact->contact_id  }}" tabindex="-1" role="dialog" aria-labelledby="modal_goruntule_label"
                                     aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="modal_goruntule_label">Mesajı</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {{ $contact->message }}
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- modal bitti-->
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="3" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">

                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">{{ trans('admin.no_contact_found') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#contacts"]').attr('aria-expanded', 'true');
            $('#contacts').addClass('show')
        });
    </script>

@endsection