@extends('adtrpanel.layouts.master')
@section('title','Yorum Yönetimi')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('admin.comments') }}</h1>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 20%;"> {{ trans('admin.comment_owner') }}</th>
                    <th style="width: 20%;"> {{ trans('admin.mail_address') }}</th>
                    <th style="width: 20%;"> {{ trans('admin.comment_date') }}</th>
                    <th style="width: 10%;"> Durum</th>
                    <th style="width: 30%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="commentlist">
                @if (count($comments) > 0 )
                    @foreach($comments as $comment)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{ $comment->name }}</td>
                            <td>{{ $comment->email }}</td>
                            <td>{{ $comment->created_at }}</td>
                            <td>
                                @if($comment->status)
                                    <span class="badge badge-success">Onaylandı</span>
                                @else
                                    <span class="badge badge-danger">Onaylanmadı</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.comments.delete', $comment->comment_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                               <a href="{{ route('adtrpanel.comments.commentform', ['id'=>$comment->comment_id,'language_id'=> 1]) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-eye"></i> İncele
                                    </button>
                                </a>
                                @if($comment->status)
                                    <a href="{{ route('adtrpanel.comments.deactivated', $comment->comment_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> Onayı Kaldır
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.comments.activated', $comment->comment_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> Onayla
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="4" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">
                            {{ $comments->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">{{ trans('admin.no_comments_found') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#comments"]').attr('aria-expanded', 'true');
            $('#comments').addClass('show')
        });
    </script>
@endsection