@extends('adtrpanel.layouts.master')
@section('title','Kategori Düzenleme Formu')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')

        <form method="post"
              action="@if(isset($category)) {{ route('adtrpanel.categories.save', $category[0]->category_id) }} @else {{ route('adtrpanel.categories.save') }} @endif"
              enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i
                                    class="fa fa-angle-left"></i> Geri
                        </button>
                    </a>
                    <button type="reset" class="btn btn-secondary-outline"><i
                                class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i>
                        Kaydet
                    </button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill"
                           href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>

                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                    <option data-toggle="pill" value="#meta_info">{{ trans('admin.meta_infos') }}</option>
                    <option data-toggle="pill" value="#image">Resim</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    @section('css')
                        <style>
                            .active {
                                display: block !important;
                            }
                        </style>
                    @endsection
                <!--Genel Bilgiler-->
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}"
                                       data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block"
                                             src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px"
                                           class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <!--Genel Bilgiler-->
                    @php $a = 0; @endphp
                         @foreach($languages as $language)
                            @php
                                @$cat = \App\Models\CategoryDetail::where('language_id',$language->language_id)->where('category_id',$category[0]->category_id)->first();
                            @endphp
                            <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">

                                        <div class="form-group row">
                                            <label for="category_name" class="col-sm-2 col-form-label">Kategori Adı <span
                                                        class=" -input">*</span>
                                            </label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control char-textarea"
                                                       name="category_name[{{$language->language_short_name}}]" maxlength="100"
                                                       data-length=100 id="category_name" placeholder="Kategori"
                                                       value="{{ @$cat->category_name }}"/>
                                            </div>



                                            <div class="col-sm-10">
                                                <input type="hidden" class="form-control char-textarea" name="category_id"
                                                       maxlength="100"
                                                       id="category_id"
                                                       value="{{ @$cat->category_id }}"/>
                                            </div>
                                        </div>


                                <div class="form-group row">
                                    <label for="category_description" class="col-sm-2 col-form-label">Kategori Açıklaması <span
                                                class="required-input">*</span></label>
                                    <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" id="category_description"
                                              name="category_description[{{$language->language_short_name}}]"
                                              placeholder="Kategori Açıklaması">{{@$cat->category_description}}</textarea>
                                    </div>
                                </div>


                                <div class="form-group row">
                                            <label for="category_meta_title" class="col-sm-2 col-form-label">Meta Title <span
                                                        class=" -input">*</span>
                                            </label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control char-textarea"
                                                       name="category_meta_title[{{$language->language_short_name}}]"
                                                       maxlength="150"
                                                       data-length=150 id="category_meta_title"
                                                       placeholder="Kategori Meta Title"
                                                       value="{{ @$cat->category_meta_title }}"/>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="category_meta_description" class="col-sm-2 col-form-label">Meta
                                                Description <span class=" -input">*</span>
                                            </label>
                                            <div class="col-sm-10">
                                        <textarea class="form-control"
                                                  name="category_meta_description[{{$language->language_short_name}}]"
                                                  id="category_meta_description" placeholder="Kategori Meta Description"
                                                  rows="3">{{@$cat->category_meta_description}}</textarea>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="slug" class="col-sm-2 col-form-label">Slug <span
                                                        class=" -input">*</span>
                                            </label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control char-textarea"
                                                       name="slug[{{$language->language_short_name}}]" maxlength="100"
                                                       data-length=100 id="slug" placeholder="Slug"
                                                       value="{{ @$cat->slug }}"/>
                                            </div>
                                        </div>
                            </div>
                    @endforeach
                <!-- Genel Bilgi Bitti -->
                </div>

            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#articles"]').attr('aria-expanded', 'true');
            $('#articles').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('news_content', {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        });
    </script>

    <script>
        var editorConfig = {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        };
        @foreach($languages as $language)
        CKEDITOR.replace('category_description[{{$language->language_short_name}}]', editorConfig);
        @endforeach

    </script>
@endsection