@extends('adtrpanel.layouts.master')
@section('title','Kategoriler')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">

        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Kategoriler</h1>
        <div class="pull-right">
            <a href="{{ route('adtrpanel.categories.new')}}" >
                <button class="btn btn-success btn-sm">
                    <i class="fa fa-add"></i> Yeni Kategori Ekle
                </button>
            </a>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>

                    <th style="width: 60%;"> Kategoriler</th>
                    <th style="width: 20%;display: none" > Kategorideki Makale Sayısı</th>
                    <th style="width: 50%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="newslist">
                @if (count($categories) > 0 )
                    @foreach($categories as $category)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{$category->category_name}}</td>
                            <td style="display: none"></td>
                            <td>
                                <a href="{{ route('adtrpanel.categories.delete', $category->category_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.categories.edit', $category->category_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                <a href="" target="_blank">
                                    <button class="btn btn-primary btn-sm">
                                        <i class="fa fa-eye"></i> Görüntüle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#articles"]').attr('aria-expanded', 'true');
            $('#articles').addClass('show')
        });
    </script>

@endsection