@extends('adtrpanel.layouts.master')
@section('title','Blog Yazıları')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <div class="text-right">
            <a href="{{route('adtrpanel.blogs.new')}}" class="btn btn-success">Yeni Blog Yazısı Ekle</a>
        </div>
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Blog Yazıları</h1>
        <div class="col-md-12">
            <div class="form-group">
                    <input type="text" name="aranan" id="aranan" class="form-control" placeholder="Aradığınız Blog Başlığını Giriniz" value="{{ old('aranan')}}" onkeyup="blogAra()" />
            </div>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 20%;"> Blog Görseli</th>
                    <th style="width: 30%;"> Blog Başlığı</th>
                    <th style="width: 5%;"> {{ trans('admin.rank') }}</th>
                    <th style="width: 5%;"> {{ trans('admin.status') }}</th>
                    <th style="width: 35%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="bloglist">
                @if (count($blog_list) > 0 )
                    @foreach($blog_list as $blog)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>@if($blog->image != null) <img src="{{ $blog->image }}" class="img-responsive" alt="{{ $blog->alt_and_title }}" width="250" /> @endif</td>
                            <td>{{ $blog->blog_title }}</td>
                            <td>{{ $blog->rank }}</td>
                            <td>
                                @if($blog->status)
                                    <span class="badge badge-success">{{ trans('admin.active') }}</span>
                                @else
                                    <span class="badge badge-danger">{{ trans('admin.passive') }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.blogs.delete', $blog->blog_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.blogs.edit', $blog->blog_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                @if($blog->status)
                                    <a href="{{ route('adtrpanel.blogs.deactivated', $blog->blog_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> {{ trans('admin.deactivated') }}
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.blogs.activated', $blog->blog_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> {{ trans('admin.activated') }}
                                        </button>
                                    </a>
                                @endif
                                <a href="{{ route('blog_detay', $blog->slug) }}" target="_blank">
                                    <button class="btn btn-primary btn-sm">
                                        <i class="fa fa-eye"></i> Görüntüle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="5" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="6">Hiç Blog bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
            {!! str_replace('/?','/',$blog_list->render()) !!}
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#blogs"]').attr('aria-expanded', 'true');
            $('#blogs').addClass('show')
        });
    </script>
    <script type="text/javascript">
        function blogAra(){
            var aranan = $("input[name='aranan']").val();
            //if (aranan != '' ) {
            var veriler = 'aranan='+aranan;
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.blogara') }}",
                data: veriler,
                dataType: "text",
                cache: false,
                success: function(sonuc){
                    $('#bloglist').html(sonuc);
                },
                error: function(xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
            //}
        }
    </script>
@endsection