@extends('adtrpanel.layouts.master')
@section('title','Blog Yazıları Düzenleme Formu')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Blog İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($blogs)) {{ route('adtrpanel.blogs.save', $blogs[0]->blog_id) }} @else {{ route('adtrpanel.blogs.save') }} @endif" enctype="multipart/form-data">
            {{ csrf_field() }}
                <div class="text-right">
                    <div class="actions btn-set">
                        <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                            </button></a>
                        <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                        @if(@isset($blogs))
                            <a href="{{route('blog', $blogs[0]->slug)}}" target="_blank">
                                <button type="button" class="btn btn-primary btn-sm">
                                    <i class="fa fa-eye"></i> Görüntüle
                                </button>
                            </a>
                        @endif
                        <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                    </div>
                </div>
                <hr>
                <!--Masaüstü Sekme Linkleri-->
                <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                    <ul class="nav nav-tabs product-tabs-select">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="pill" href="#meta_info">{{ trans('admin.meta_infos') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="pill" href="#image">Resim</a>
                        </li>
                        @if($hook = do_action('adtrpanel.menu.after', []))
                            @foreach($hook['return'] as $val)
                                @if(!empty($val))
                                    {!! $val !!}
                                @endif
                            @endforeach
                        @endif
                        @if($hook = do_action('adtrpanel.blogMenu', []))
                            @foreach($hook['return'] as $val)
                                @if(!empty($val))
                                    {!! $val !!}
                                @endif
                            @endforeach
                        @endif
                    </ul>
                </div>
                <!--Masaüstü Sekme Linkleri Bitti-->

                <!--Mobil Sekme Linkleri-->
                <div class="d-lg-none d-sm-block tabs-mobile">
                    <select title="Sekme seçiniz" class="mobile-select">
                        <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                        <option data-toggle="pill" value="#meta_info">{{ trans('admin.meta_infos') }}</option>
                        <option data-toggle="pill" value="#image">Resim</option>
                    </select>
                </div>
                <!--Mobil Sekme Linkleri Bitti-->


                <!-- Tab panes -->
                <div class="tab-content">
                    <div class="tab-pane active" id="general_info">
                        @section('css')
                            <style>
                                .active {display:block!important;}
                            </style>
                        @endsection
                    <!--Genel Bilgiler-->
                        <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                            <ul class="nav nav-tabs product-tabs-select">
                                @foreach($languages as $language)
                                    <li class="nav-item">
                                        <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}">
                                            <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                            <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        @php $a = 0; @endphp
                        @foreach($languages as $language)

                                @php
                                    @$blog = \App\Models\BlogDetail::where('language_id',$language->language_id)->where('blog_id',$blogs[0]->blog_id)->first();
                                @endphp
                            <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">
                                <div class="form-group row">
                                    <label for="blog_title" class="col-sm-2 col-form-label">Blog Başlığı <span class=" -input">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control char-textarea" name="blog_title[{{$language->language_short_name}}]"   maxlength="100"
                                               data-length=100 id="blog_title" placeholder="Blog Başlığı" value="{{@$blog->blog_title}}" />
                                        <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="blog_content" class="col-sm-2 col-form-label">Blog İçeriği <span
                                                class=" -input">*</span></label>
                                    <div class="col-sm-10">
                                        <textarea class="form-control" rows="5" id="blog_content" name="blog_content[{{$language->language_short_name}}]" placeholder="Blog İçeriği">{{@$blog->blog_content}}</textarea>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="status" class="col-sm-2 col-form-label">{{ trans('admin.status') }}</label>
                                    <div class="col-sm-6">
                                        <select id="status" class="form-control" name="status[{{$language->language_short_name}}]">
                                            <option value="0" @if(@$blog->status == 0) selected="selected" @endif>{{ trans('admin.passive') }}</option>
                                            <option value="1" @if(@$blog->status == 1) selected="selected" @endif>{{ trans('admin.active') }}</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="rank" class="col-sm-2 col-form-label">{{ trans('admin.rank') }}</label>
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" name="rank[{{$language->language_short_name}}]" id="rank" placeholder="Blog sıra Numarası" value="{{@$blog->rank}}" />
                                    </div>
                                </div>
                            </div>

                        @endforeach
                    <!-- Genel Bilgi Bitti -->
                    </div>
                    <div class="tab-pane" id="meta_info">
                        <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                            <ul class="nav nav-tabs product-tabs-select">
                                @foreach($languages as $language)
                                    <li class="nav-item">
                                        <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}_meta">
                                            <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                            <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        @php $a = 0; @endphp
                        @foreach($languages as $language)

                            @php
                                @$blogX = \App\Models\BlogDetail::where('language_id',$language->language_id)->where('blog_id',$blogs[0]->blog_id)->first();
                            @endphp
                            <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}_meta">
                                <!--Meta Bilgileri-->
                                <div class="form-group row">
                                    <label for="blog_meta_title" class="col-sm-2 col-form-label">{{ trans('admin.meta_title') }}
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control char-textarea" name="blog_meta_title[{{$language->language_short_name}}]"   maxlength="100"
                                               data-length=100 id="blog_meta_title" placeholder="Blog Meta Başlığı" value="{{@$blogX->blog_meta_title}}" />
                                        <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="blog_meta_description" class="col-sm-2 col-form-label">{{ trans('admin.meta_description') }} </label>
                                    <div class="col-sm-10">
                                        <textarea class="form-control" rows="5" id="blog_meta_description" name="blog_meta_description[{{$language->language_short_name}}]" placeholder="Blog Meta Açıklaması">{{@$blogX->blog_meta_description}}</textarea>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="blog_meta_keywords" class="col-sm-2 col-form-label">{{ trans('admin.meta_keywords') }} </label>
                                    <div class="col-sm-10">
                                        <textarea class="form-control" rows="5" id="blog_meta_keywords" name="blog_meta_keywords[{{$language->language_short_name}}]" placeholder="Blog Meta Keywords">{{@$blogX->blog_meta_keywords}}</textarea>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="slug" class="col-sm-2 col-form-label">Blog SEO Urlsi <i class="fas fa-question-circle info-circle" data-html="true" data-toggle="tooltip" data-placement="right" title="Yazıya özel url tanımlamak isterseniz bu alanı doldurunuz.<br />Örn: yazi-basligi-ozel-url<br />Boş bırakırsanız yazı başlığı SEO URL ye dönüştürülecektir."></i></label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" name="slug[{{$language->language_short_name}}]" id="slug" placeholder="Blog SEO Urlsi" value="{{@$blogX->slug}}" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="seo_description" class="col-sm-2 col-form-label">Blog SEO Description <i class="fas fa-question-circle info-circle" data-html="true" data-toggle="tooltip" data-placement="right" title="Seo içeriği"></i></label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" name="seo_description[{{$language->language_short_name}}]" id="seo_description" placeholder="Blog SEO description" value="{{@$blogX->seo_description}}" />
                                    </div>
                                </div>
                                <!--Meta Bilgileri Bitti-->
                            </div>
                            @php $a++; @endphp
                        @endforeach
                    </div>
                    <div class="tab-pane" id="image">
                        <!--Resim Bilgileri-->
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr role="row" class="heading">
                                <th width="40%"> Resim </th>
                                <th width="60%"> Resim Alt ve Title Tagı Bilgisi </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td class="text-center">
                                    <input type="file" name="image" class="form-control"  />
                                    <small class="text-muted">800 x 400 piksel olmalıdır.</small>
                                    <img src="{{ @$blogs[0]->image }}" alt="{{ @$blogs[0]->alt_and_title }}" class="img-responsive" />
                                </td>
                                <td>
                                    <input type="text" name="alt_and_title" value="{{ @$blogs[0]->alt_and_title }}" class="form-control char-textarea" placeholder="" maxlength="100" data-length="100"  />
                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!--Resim Bilgileri Bitti-->
                    </div>
                    @if($hook = do_action('adtrpanel.content.after', ['parameter' => 'blog_id', 'id' => isset($blogs[0]->blog_id) ? $blogs[0]->blog_id : null]))
                        @foreach($hook['return'] as $val)
                            @if(!empty($val))
                                {!! $val !!}
                            @endif
                        @endforeach
                    @endif
                </div>
        </form>
    </section>
    <!--Blog İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#blogs"]').attr('aria-expanded', 'true');
            $('#blogs').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        var editorConfig = {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        };
        @foreach($languages as $language)
            CKEDITOR.replace( 'blog_content[{{$language->language_short_name}}]',  editorConfig);
        @endforeach

    </script>
@endsection