@extends('adtrpanel.layouts.master')
@if(isset($dealer))
    @section('title','Bayiler Düzenleme Formu')
@else
    @section('title','Bayi Ekle')
    @endif
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post"
              action="@if(isset($dealer))   {{ route('adtrpanel.dealer.save',$dealer[0]['id']) }}     @else{{ route('adtrpanel.dealer.save') }} @endif"
              enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i
                                    class="fa fa-angle-left"></i> Geri
                        </button>
                    </a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i>
                        Kaydet
                    </button>
                </div>
            </div>
            <hr>


            <div class="container">
                <div class="form-group row">
                    <label for="image" class="col-sm-2 col-form-label">Logo<span class="required-input">*</span>
                    </label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control char-textarea" name="image" id="photo_image"  @if(isset($dealer)) value="{{@$dealer[0]['image']}}" @endif>
                        <img src="@if(isset($dealer))/{{@$dealer[0]['image']}} @endif" class="img-fluid" width="150">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="name" class="col-sm-2 col-form-label">Firma adı</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control char-textarea" name="name" @if(isset($dealer))  value="{{@$dealer[0]['adi']}}"  @endif maxlength="100" data-length=100 id="name" placeholder="Firma Adı"/>
                        <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="url" class="col-sm-2 col-form-label">URL</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control " name="url" id="price" placeholder="URL" @if(isset($dealer)) value="{{@$dealer[0]['url']}}"  @endif />
                    </div>
                </div>
                <div class="form-group row">
                    <label for="sort_order" class="col-sm-2 col-form-label">Sıra No

                    </label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control " name="sort_order" id="sort_order" placeholder="Sıra No" @if(isset($dealer)) value="{{@$dealer[0]['sort_order']}}" @endif/>
                    </div>
                </div>
                <div class="row form-group">
                    <label for="" class="col-sm-2 col-form-label">Durum</label>
                    <div class="col-sm-10">
                        <select name="status" class="form-control">
                            @if(isset($dealer[0]['status']) == 0)
                                <option value="1">Acık</option>
                                <option value="0" selected>Kapalı</option>
                             @else
                                <option value="1" selected>Acık</option>
                                <option value="0">Kapalı</option>
                            @endif
                        </select>
                    </div>
                </div>
            </div>






        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')

@endsection
@section('js')
    <script src="/admin/js/autocomplete.js"></script>
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#dealer"]').attr('aria-expanded', 'true');
            $('#dealer').addClass('show')
        });
    </script>







@endsection