@extends('adtrpanel.layouts.master')
@section('title','Bayiler')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('Bayiler') }}</h1>
        <div class="text-right">
            <div class="actions btn-set">
                <a href="{{route('adtrpanel.dealer.add')}}" class="btn btn-success"><i class="fa fa-check"></i> Yeni Bayi Ekle</a>
            </div>
        </div>
        <!--İletişim Talepleri-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 3%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 50%;"> {{ trans('Adı') }}</th>
                    <th style="width: 30%;"> {{trans('Resim')}}</th>
                    <th style="width: 20%;"> </th>
                </tr>
                </thead>
                <tbody id="sliderlist">
                    @if (count($dealers) > 0 )
                    @foreach($dealers as $dealer)

                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{ $dealer->adi }} </td>
                            <td><img src="/{{$dealer->image}}" height="160" width="160"> </td>
                            <td>
                                <a href="{{ route('adtrpanel.dealer.delete', $dealer->id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.dealer.edit', $dealer->id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-eye"></i> Düzenle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach

                    <tr>
                        <td colspan="2" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">

                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">{{ trans('admin.no_contact_found') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        {!! $dealers->render() !!}
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#dealer"]').attr('aria-expanded', 'true');
            $('#human').addClass('show')
        });
    </script>

@endsection