@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Makaleler</h1>
        <div class="col-md-12">
            <div class="form-group">
                    <input type="text" name="aranan" id="aranan" class="form-control" placeholder="Aradığınız Makale Başlığını Giriniz" value="{{ old('aranan')}}" onkeyup="articleAra()" />
            </div>
            <div class="form-group">
                <label for="">Makale Dili:</label>
                <select name="language" class="form-control col-4" id="" onchange="articleAra()">
                    @foreach(\App\Models\Language::all() as $language)
                        <option value="{{$language->language_id}}">{{$language->language_details}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 15%;"> Makale Görseli</th>
                    <th style="width: 25%;"> Makale Başlığı</th>
                    <th style="width: 15%;"> Kategorisi</th>
                    <th style="width: 5%;"> {{ trans('admin.rank') }}</th>
                    <th style="width: 5%;"> {{ trans('admin.status') }}</th>
                    <th style="width: 30%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="article_list">
                @if (count($article_list) > 0 )
                    @foreach($article_list as $article)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td><img src="{{ $article->image }}" class="img-responsive" alt="{{ $article->alt_and_title }}" width="250" /></td>
                            <td>{{ $article->article_title }}</td>
                            <td>{{ $article->category->category_name }}</td>
                            <td>{{ $article->rank }}</td>
                            <td>
                                @if($article->status)
                                    <span class="badge badge-success">{{ trans('admin.active') }}</span>
                                @else
                                    <span class="badge badge-danger">{{ trans('admin.passive') }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="#" id="delete" data-href="{{ route('adtrpanel.articles.delete', $article->article_id) }}">
                                    <button id="delete" class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.articles.edit', $article->article_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                @if($article->status)
                                    <a href="{{ route('adtrpanel.articles.deactivated', $article->article_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> {{ trans('admin.deactivated') }}
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.articles.activated', $article->article_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> {{ trans('admin.activated') }}
                                        </button>
                                    </a>
                                @endif
                                <a href="{{route('article', [$article->category->slug, $article->slug])}}" target="_blank">
                                    <button class="btn btn-primary btn-sm">
                                        <i class="fa fa-eye"></i> Görüntüle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="6" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="7">
                            {{ $article_list->appends(['aranan' => old('aranan')])->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="7">Hiç makale bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        $(document).ready(function () {
            $('a#delete').on('click', function () {
                swal({
                    type: 'question',
                    title: 'Emin Misiniz ?',
                    text: 'Bu makaleyi silmek istediğinize emin misin?',
                    showCancelButton: true,
                    confirmButtonText: 'Evet',
                    cancelButtonText: 'Hayır'
                }).then((result) => {
                    if (result.value) {
                        var url = $(this).attr('data-href');
                        window.location.href = url
                    }
                })
            })
        });
    </script>
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#articles"]').attr('aria-expanded', 'true');
            $('#articles').addClass('show')
        });
    </script>
    <script type="text/javascript">
        function articleAra(){
            var aranan = $("input[name='aranan']").val();
            var language = $("select[name='language']").val();
            //if (aranan != '' ) {
            var veriler = 'aranan='+aranan+'&language_id='+language;
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.articleara') }}",
                data: veriler,
                dataType: "text",
                cache: false,
                success: function(sonuc){
                    $('#article_list').html(sonuc);
                },
                error: function(xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
            //}
        }
    </script>
@endsection