@extends('adtrpanel.layouts.master')

@section('content')

    <!--Header-->

    @include('adtrpanel.partials.header')

    <!--Header Bitti-->

    <!--Sayfa İçeriği-->

    <section class="page-content">

        @include('adtrpanel.partials.errors')

        @include('adtrpanel.partials.alert')

        <form method="post" action="@if(isset($article)) {{ route('adtrpanel.articles.save', $article[0]->article_id) }} @else {{ route('adtrpanel.articles.save') }} @endif" enctype="multipart/form-data">

            {{ csrf_field() }}

            <div class="text-right">

                <div class="actions btn-set">

                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri

                        </button></a>

                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>


                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>

                </div>

            </div>

            <hr>

            <!--Masaüstü Sekme Linkleri-->

            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">

                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#meta_info">{{ trans('admin.meta_infos') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#image">Resim ve Diğer</a>
                    </li>
                    @if($hook = do_action('adtrpanel.menu.after', []))
                        @foreach($hook['return'] as $val)
                            @if(!empty($val))
                                {!! $val !!}
                            @endif
                        @endforeach
                    @endif

                </ul>

            </div>

            <!--Masaüstü Sekme Linkleri Bitti-->



            <!--Mobil Sekme Linkleri-->

            <div class="d-lg-none d-sm-block tabs-mobile">

                <select title="Sekme seçiniz" class="mobile-select">

                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>

                    <option data-toggle="pill" value="#meta_info">{{ trans('admin.meta_infos') }}</option>

                    <option data-toggle="pill" value="#image">Resim ve Diğer</option>

                </select>

            </div>

            <!--Mobil Sekme Linkleri Bitti-->

            <!-- Tab panes -->

            <div class="tab-content">
                <div class="tab-pane active" id="general_info">

                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">

                        <ul class="nav nav-tabs product-tabs-select">

                            @foreach($languages as $language)

                                <li class="nav-item">

                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}">

                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">

                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>

                                    </a>

                                </li>

                            @endforeach

                        </ul>

                    </div>

                    @php $a = 0; @endphp

                    @foreach($languages as $language)

                        @php

                            @$articleX = \App\Models\ArticleDetail::where('language_id',$language->language_id)->where('article_id',$article[0]->article_id)->first();

                        @endphp

                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">

                            <div class="form-group row">

                                <label for="article_title" class="col-sm-2 col-form-label">Haber Başlığı <span class=" -input">*</span>

                                </label>

                                <div class="col-sm-10">

                                    <input type="text" class="form-control char-textarea" name="article_title[{{$language->language_short_name}}]"   maxlength="100"

                                           data-length=100 id="article_title" placeholder="Makale Başlığı"value="{{ @$articleX->article_title }}"/>

                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>

                                </div>

                            </div>

                            <div class="form-group row">

                                <label for="article_content" class="col-sm-2 col-form-label">Haber İçeriği <span

                                            class=" -input">*</span></label>

                                <div class="col-sm-10">

                                    <textarea class="form-control" rows="5" id="article_content" name="article_content[{{$language->language_short_name}}]" placeholder="Haber İçeriği">{{ @$articleX->article_content }}</textarea>

                                </div>

                            </div>

                            <div class="form-group row">

                                <label for="status" class="col-sm-2 col-form-label">{{ trans('admin.status') }}</label>

                                <div class="col-sm-6">

                                    <select id="status" class="form-control" name="status[{{$language->language_short_name}}]">

                                        <option value="0" @if(@$articleX->status == 0) selected="selected" @endif>{{ trans('admin.passive') }}</option>

                                        <option value="1" @if(@$articleX->status == 1) selected="selected" @endif>{{ trans('admin.active') }}</option>

                                    </select>

                                </div>

                            </div>

                            <div class="form-group row">

                                <label for="category_id" class="col-sm-2 col-form-label">Bağlı Olduğu Kategori</label>

                                <div class="col-sm-6">

                                    <select id="category_id" class="form-control" name="category_id[{{$language->language_short_name}}]">
                                        @foreach($categories as $category)

                                            @if($category->language_id == $language->language_id)

                                                <option value="{{ $category->category_id }}" @if(isset($articleX) && @$articleX->category_id == $category->category_id) selected="selected" @endif>{{ $category->category_name }}</option>

                                            @endif

                                        @endforeach

                                    </select>

                                </div>

                            </div>

                            <div class="form-group row">

                                <label for="rank" class="col-sm-2 col-form-label">{{ trans('admin.rank') }}</label>

                                <div class="col-sm-6">

                                    <input type="text" class="form-control" name="rank[{{$language->language_short_name}}]" id="rank" placeholder="Sayfa sıra Numarası" value="{{ @$articleX->rank }}"/>

                                </div>

                            </div>

                        </div>



                @endforeach

                <!-- Genel Bilgi Bitti -->

                </div>
                <div class="tab-pane" id="meta_info">

                    <!--Meta Bilgileri-->

                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">

                        <ul class="nav nav-tabs product-tabs-select">

                            @foreach($languages as $language)

                                <li class="nav-item">

                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}_meta">

                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">

                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>

                                    </a>

                                </li>

                            @endforeach

                        </ul>

                    </div>

                    @php $a = 0; @endphp

                    @foreach($languages as $language)

                        @php

                            @$articleZ = \App\Models\ArticleDetail::where('language_id',$language->language_id)->where('article_id',$article[0]->article_id)->first();

                        @endphp

                        <div class="tab-pane {{$language->language_default == 1 ? "active" : ""}}" style="display: none;" id="{{$language->language_short_name}}_meta">

                            <!--Meta Bilgileri-->

                            <div class="form-group row">

                                <label for="article_meta_title" class="col-sm-2 col-form-label">{{ trans('admin.meta_title') }}

                                </label>

                                <div class="col-sm-10">

                                    <input type="text" class="form-control char-textarea" name="article_meta_title[{{$language->language_short_name}}]"   maxlength="100"

                                           data-length=100 id="article_meta_title" placeholder="Sayfa Meta Başlığı" value="{{ @$articleZ->article_meta_title }}" />

                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>

                                </div>

                            </div>

                            <div class="form-group row">

                                <label for="article_meta_description" class="col-sm-2 col-form-label">{{ trans('admin.meta_description') }} </label>

                                <div class="col-sm-10">

                                    <textarea class="form-control" rows="5" id="article_meta_description" name="article_meta_description[{{$language->language_short_name}}]" placeholder="Sayfa Meta Açıklaması">{{@$articleZ->article_meta_description}}</textarea>

                                </div>

                            </div>

                            <div class="form-group row">

                                <label for="article_meta_keywords" class="col-sm-2 col-form-label">{{ trans('admin.meta_keywords') }} </label>

                                <div class="col-sm-10">

                                    <textarea class="form-control" rows="5" id="article_meta_keywords" name="article_meta_keywords[{{$language->language_short_name}}]" placeholder="Sayfa Meta Keywords">{{@$articleZ->article_meta_keywords}}</textarea>

                                </div>

                            </div>

                            <div class="form-group row">

                                <label for="slug" class="col-sm-2 col-form-label">Haber SEO Urlsi <i class="fas fa-question-circle info-circle" data-html="true" data-toggle="tooltip" data-placement="right" title="Yazıya özel url tanımlamak isterseniz bu alanı doldurunuz.<br />Örn: yazi-basligi-ozel-url<br />Boş bırakırsanız yazı başlığı SEO URL ye dönüştürülecektir."></i></label>

                                <div class="col-sm-6">

                                    <input type="hidden" name="original_slug" value="{{ @$articleZ->slug }}">

                                    <input type="text" class="form-control" name="slug[{{$language->language_short_name}}]" id="slug" placeholder="Haber SEO Urlsi" value="{{ @$articleZ->slug }}"/>

                                </div>

                            </div>

                            <!--Meta Bilgileri Bitti-->

                        </div>

                    @php $a++; @endphp

                @endforeach

                <!--Meta Bilgileri Bitti-->

                </div>
                <div class="tab-pane" id="image">

                    <!--Resim Bilgileri-->

                    <table class="table table-bordered table-hover">

                        <thead>

                        <tr role="row" class="heading">

                            <th width="25%"> Resim </th>

                            <th width="25%"> Resim Alt ve Title Tagı Bilgisi </th>

                            <th width="25%"> İleri Zamanlı Paylaşım </th>
                            <th width="25%"> Makale Yazarı </th>

                        </tr>

                        </thead>

                        <tbody>

                        <tr>

                            <td class="text-center">

                                <input type="file" name="image" class="form-control"  />

                                <small class="text-muted">800 x 400 piksel olmalıdır.</small>

                                <img src="{{ @$article[0]->image }}" alt="{{ @$article[0]->alt_and_title }}" class="img-responsive" />

                            </td>

                            <td>

                                <input type="text" name="alt_and_title" value="{{ @$article[0]->alt_and_title }}" class="form-control char-textarea" placeholder="" maxlength="100" data-length="100"  />

                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>

                            </td>

                            <td>
                                <input type="datetime-local" class="form-control" name="published_at">
                            </td>
                            <td>
                                <select name="author" class="form-control" required>
                                    @foreach($authors as $author)
                                        <option value="{{$author->medical_staff_id}}" @if(@$articleX->author == $author->medical_staff_id) selected @endif >{{$author->name}} {{$author->surname}}</option>
                                    @endforeach
                                </select>
                            </td>

                        </tr>

                        </tbody>

                    </table>

                    <!--Resim Bilgileri Bitti-->

                </div>
                @if($hook = do_action('adtrpanel.content.after', ['parameter' => 'article_id', 'id' => isset($article[0]->article_id) ? $article[0]->article_id : null]))
                    @foreach($hook['return'] as $val)
                        @if(!empty($val))
                            {!! $val !!}
                        @endif
                    @endforeach
                @endif

            </div>

        </form>

    </section>

    <!--Sayfa İçeriği Bitti-->

@endsection

@section('css')
    <style>
        .active {display:block!important;}
    </style>
@endsection

@section('js')

    <script>

        // Akordion açtırma

        $(document).ready(function () {

            $('*[data-target="#articles"]').attr('aria-expanded', 'true');

            $('#articles').addClass('show')

        });

    </script>

    <script src="/ckeditor/ckeditor.js"></script>

    <script>

        var editorConfig = {

            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',

            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'

        };

        @foreach($languages as $language)

        CKEDITOR.replace( 'article_content[{{$language->language_short_name}}]',  editorConfig);

        @endforeach



    </script>

@endsection