@extends('adtrpanel.layouts.master')
@section('content')
@include('adtrpanel.partials.header')
<section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Randevu Konuları</h1>
        <div class="pull-right">
            <a href="{{ route('adtrpanel.appointments.subjects.add')}}" >
                <button class="btn btn-success btn-sm">
                    <i class="fa fa-add"></i> Yeni Randevu Konusu Ekle
                </button>
            </a>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 40%;"> Name</th>
                    <th style="width: 20%;"> Rank </th>
                    <th style="width: 50%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="newslist">
                @if (count($subjects) > 0 )
                    @foreach($subjects as $subject)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{ $subject->name }}</td>
                            <td>{{ $subject->rank }}</td>
                            <td>
                                <a href="{{ route('adtrpanel.appointments.subjects.delete', $subject->subject_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.appointments.subjects.add', $subject->subject_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>

                                @if($subject->status)
                                    <a href="{{ route('adtrpanel.appointments.subjects.deactivated', $subject->subject_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> Pasif Et
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.appointments.subjects.activated', $subject->subject_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> Aktif Et
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
</section>
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#appointments"]').attr('aria-expanded', 'true');
            $('#appointments').addClass('show')
        });
    </script>

@endsection