@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">

        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Randevular</h1>

        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 40%;">Ad Soyad</th>
                    <th>Telefon</th>
                    <th>Konu</th>
                    <th style="width: 20%;">Tarihi</th>
                    <th style="width: 50%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="newslist">
                @if (count($appointments) > 0 )
                    @foreach($appointments as $appointment)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{$appointment->adsoyad}}</td>
                            <td>
                                {{ $appointment->telefon}}
                            </td>
                            <td>
                                {{ $appointment->getSubject->name }}
                            </td>
                            <td>{{ \Carbon\Carbon::parse($appointment->randevu_tarihi)->format('d-m-Y')}}</td>
                            <td>
                                <a href="{{ route('adtrpanel.appointments.delete', $appointment->randevu_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                @if($appointment->status)
                                    <a href="{{ route('adtrpanel.appointments.deactivated', $appointment->randevu_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                           Okunmuş[Yeni Randevulara Ata]
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.appointments.activated', $appointment->randevu_id) }}">
                                        <button class="btn btn-success btn-sm">
                                          Yeni Randevu [Okunmuşlara Ata]
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#appointments"]').attr('aria-expanded', 'true');
            $('#appointments').addClass('show')
        });
    </script>

@endsection