@extends('adtrpanel.layouts.master')
@section('content')
@include('adtrpanel.partials.header')
<section class="page-content">
@include('adtrpanel.partials.errors')
@include('adtrpanel.partials.alert')
<form method="post" action="@if(isset($appointmentSubjects)) {{ route('adtrpanel.appointments.subjects.save', $appointmentSubjects[0]->subject_id) }} @else {{ route('adtrpanel.appointments.subjects.save') }} @endif"
              enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i
                                    class="fa fa-angle-left"></i> Geri
                        </button>
                    </a>
                    <button type="reset" class="btn btn-secondary-outline"><i
                                class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i>
                        Kaydet
                    </button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill"
                           href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>

                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                    <option data-toggle="pill" value="#meta_info">{{ trans('admin.meta_infos') }}</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    @section('css')
                        <style>
                            .active {
                                display: block !important;
                            }
                        </style>
                    @endsection
                <!--Genel Bilgiler-->
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}"
                                       data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block"
                                             src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px"
                                           class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <!--Genel Bilgiler-->
                    @php $a = 0; @endphp
                    @foreach($languages as $language)
                        @php
                            @$subject = \App\Models\AppointmentSubjectDetail::where('language_id',$language->language_id)->where('subject_id',$appointmentSubjects[0]->subject_id)->first();
                        @endphp
                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">
                            <div class="form-group row">
                                <label for="name" class="col-sm-2 col-form-label">Konu Adı <span  class=" -input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea" name="name[{{$language->language_short_name}}]" maxlength="100"   data-length=100 id="category_name" placeholder="Konu" value="{{ @$subject->name}}"/>
                                </div>
                                <div class="col-sm-10">
                                    <input type="hidden" class="form-control char-textarea" name="subject_id"  maxlength="100" id="subject_id" value="{{ @$subject->subject_id }}"/>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="status" class="col-sm-2 col-form-label">{{ trans('admin.status') }}</label>
                                <div class="col-sm-6">
                                    <select id="status" class="form-control" name="status[{{$language->language_short_name}}]">
                                        <option value="0" @if(@$subject->status == 0) selected="selected" @endif>{{ trans('admin.passive') }}</option>
                                        <option value="1" @if(@$subject->status == 1) selected="selected" @endif>{{ trans('admin.active') }}</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-2 col-form-label">Rank <span  class=" -input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea" name="rank[{{$language->language_short_name}}]" maxlength="100"  data-length=100 id="rank" placeholder="Rank" value="{{ @$subject->rank}}"/>
                                </div>

                            </div>
                        </div>
                @endforeach
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#appointments"]').attr('aria-expanded', 'true');
            $('#appointments').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('news_content', {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        });
    </script>
@endsection