<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'   => ':attribute doit être accepté.',
    'active_url' => ':attribute doit être une URL valide.',
    'after'      => ': La valeur de :attribute doit être une date postérieure à date....',
    'after_or_equal' => 'La valeur de :attribute doit être une date postérieure à date ou la même date que la date.',
    'alpha'      => ':attribute ne doit contenir que des lettres',
    'alpha_dash' => ':attribute ne doit contenir que des lettres, des chiffres et des tirets.',
    'alpha_num'  => ':attribute ne doit contenir que des lettres et des chiffres.',
    'array'      => ':attribute doit être une série.',
    'before'     => ': La valeur :attribute doit être une date antérieure :date.',
    'before_or_equal' => 'La valeur :attribute doit être identique à la date  ou une date antérieure.',
    'between'    => [
        'numeric' => ':attribute doit être compris entre min -: max.',
        'file'    => ':attribute doit avoir une valeur en kilo-octets comprise entre min - max.',
        'string'  => ':attribute doit être composé de min -: max caractères',
        'array'   => ':attribute doit avoir l\'objet entre min -: max.',
    ],
    'boolean'        => 'Le champ :attribute ne peut être que vrai ou incorrect.',
    'confirmed'      => 'la répétition :attribute ne correspond pas.',
    'date'           => ':attribute doit être une date valide.',
    'date_format'    => ':attribute ne correspond pas au format.',
    'different'      => ':attribute doit être différent de l\'autre.',
    'digits'         => ':attribute doit être des chiffres digitaux.',
    'digits_between' => ':attribute doit être un chiffre entre min et max.',
    'dimensions'     => ':attribute a des dimensions d\'image non valides.',
    'distinct'       => 'Le champ :attribute a une valeur répétée.',
    'email'          => ':attribute doit être un e-mail correct.',
    'exists'         => ':attribute sélectionné invalide.',
    'file'           => ':attribute doit être un fichier.',
    'filled'         => 'Le champ :attribute doit contenir une valeur.',
    'image'          => ':attribute doit être un fichier image.',
    'in'             => 'La valeur :attribute n\'est pas valide.',
    'in_array'       => ': valeur :attribute non disponible dans l\'autre.',
    'integer'        => ':attribute doit être le chiffre.',
    'ip'             => ':attribute doit être une adresse IP valide.',
    'ipv4'           => ':attribute doit avoir être une adresse IPv4 valide.',
    'ipv6'           => ':attribute doit être une adresse IPv6 valide.',
    'json'           => ':attribute doit être une chaîne JSON valide.',
    'max'            => [
        'numeric' => 'valeur :attribute ne doit pas être supérieure à max',
        'file'    => 'valeur :attribute ne doit pas être supérieure à la valeur max en kilo-octets',
        'string'  => 'La valeur :attribute doit être dans la longueur maximum de max caractères.',
        'array'   => 'La valeur :attribute ne devrait pas avoir d\'éléments plus que max objets.',
    ],
    'mimes' => 'format de fichier :attribute doit être les valeurs.',
    'mimetypes'  => 'format de fichier :attribute doit être les valeurs',
    'min'   => [
        'numeric' => 'La valeur :attribute doit être au moins :min',
        'file'    => 'La valeur :attribute doit être au moins :min en kilo-octets.',
        'string'  => 'La valeur :attribute doit être au moins :min caractères.',
        'array'   => ':attribute doit avoir au moins: objet :min.',
    ],
    'not_in'               => 'Selectionné :attribute est invalide.',
    'numeric'              => ':attribute doit être le chiffre.',
    'present'              => 'Le champ :attribute doit exister.',
    'regex'                => 'le format :attribute est invalide.',
    'required'             => 'champ :attribute requis.',
    'required_if'          => 'le champ :attribute est obligatoire quand :other :value.',
    'required_unless'      => 'le champ :attribute est obligatoire lorsque :other n\'a pas de :value.',
    'required_with'        => 'champ :attribute obligatoire lorsqu\'il y a des :values.',
    'required_with_all'    => 'champ :attribute obligatoire lorsqu\'il y a des :values.',
    'required_without'     => 'champ :attribute obligatoire en l\'absence de :value.',
    'required_without_all' => 'champ :attribute obligatoire en l\'absence de :value.',
    'same'                 => 'attribute doit correspondre avec :other.',
    'size'                 => [
        'numeric' => ':attribute devrait être la :size.',
        'file'    => ':attribute devrait être la :size en kilo-octets.',
        'string'  => ':attribute devrait être la :size en caractères.',
        'array'   => ':attribute la :size doit avoir l\'objet.',
    ],
    'string'   => ':attribute doit se composer de caractères.',
    'timezone' => ':attribute doit être un fuseau horaire valide.',
    'unique'   => ':attribute est déjà enregistré.',
    'uploaded' => 'Erreur lors du chargement :attribute.',
    'url'      => 'le format :attribute est invalide.',


    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes' => [
        'name' => 'Prénom-nom',
        'email' => 'Email',
        'password' => 'Mot de passe',
    ],

];
