<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'   => ':attribute debe ser aceptado.',
    'active_url' => ':attribute debe ser una URL válido.',
    'after'      => 'El valor de :attribute debe ser una fecha posterior a :date.',
    'after_or_equal' => 'El valor de :attribute debe ser posterior a :date o la misma fecha.',
    'alpha'      => ':attribute solo debe contener letras',
    'alpha_dash' => ':attribute solo debe contener letras, números y guiones.',
    'alpha_num'  => ':attribute debe contener solo letras y números.',
    'array'      => ':attribute debe ser una secuencia.',
    'before'     => 'El valor de :attribute debe ser una fecha anterior a :date.',
    'before_or_equal' => 'El valor de :attribute debe ser el mismo que la fecha :date o anterior.',
    'between'    => [
        'numeric' => ':attribute debe estar entre :min - :max',
        'file'    => ':attribute debe tener un valor de kilobytes entre :min - :max.',
        'string'  => ':attribute debe constar de caracteres entre :min - :max.',
        'array'   => ':attribute debe tener objeto entre :min - :max.',
    ],
    'boolean'        => 'El campo de :attribute solo puede ser correcto o incorrecto.',
    'confirmed'      => 'La repetición de :attribute no coincide.',
    'date'           => ':attribute debe ser una fecha válida.',
    'date_format'    => ':attribute no coincide con el formato.',
    'different'      => ':attribute y : other deben ser diferentes el uno del otro.',
    'digits'         => ':attribute: deben ser :digits dígitos',
    'digits_between' => ':attribute debe ser un número entre :min ile :max',
    'dimensions'     => ':attribute tiene dimensiones de imagen inválidas.',
    'distinct'       => 'El campo de :attribute tiene un valor repetido.',
    'email'          => ':attribute debe ser un correo electrónico correcto.',
    'exists'         => 'El campo seleccionado  :attribute no es válido.',
    'file'           => ' :attribute debe ser archivo.',
    'filled'         => 'El campo de  :attribute debe contener un valor.',
    'image'          => ' :attribute debe ser un archivo de imagen.',
    'in'             => 'El valor de :attribute no es válido.',
    'in_array'       => 'El valor de  :attribute no disponible en :other.',
    'integer'        => ' :attribute debe ser un número.',
    'ip'             => ' :attribute debe tener una dirección IP válida.',
    'ipv4'           => ' :attribute debe tener una dirección IPv4 válida.',
    'ipv6'           => ' :attribute debe ser una dirección IPv6 válida.',
    'json'           => ' :attribute debe ser una cadena JSON válida.',
    'max'            => [
        'numeric' => 'EL valor de  :attribute no debe ser mayor que :max.',
        'file'    => 'El valor de :attribute  no debe ser mayor que el valor de kilobytes :max.',
        'string'  => 'El valor de :attribute debe ser máximo :max caracteres de longitud.',
        'array'   => 'El valor de :attribute no debe tener más de :max objetos.',
    ],
    'mimes' => 'El formato de archivo de :attribute debe ser :values',
    'mimetypes'  => 'El formato de archivo de :attribute debe ser :values',
    'min'   => [
        'numeric' => 'El valor de:attribute debe ser al menos :min.',
        'file'    => 'El valor de :attribute debe ser al menos :min kilobytes.',
        'string'  => 'El valor de :attribute debe tener al menos :min caracteres de longitud.',
        'array'   => ':attribute debe tener al menos :min objetos.',
    ],
    'not_in'               => 'Seleccionado: :attribute no es válido.',
    'numeric'              => ':attribute debe ser un número.',
    'present'              => 'El campo de :attribute debe existir.',
    'regex'                => 'El formato de :attribute no es válido.',
    'required'             => 'EL campo de :attribute es requerido.',
    'required_if'          => 'El campo de:attribute es obligatorio cuando :otro tiene el valor :values.',
    'required_unless'      => 'El campo de :attribute es obligatorio cuando :otro no tiene el valor :values.',
    'required_with'        => 'El campo de :attribute es obligatorio cuando hay :values.',
    'required_with_all'    => 'El campo de :attribute es obligatorio cuando hay :values.',
    'required_without'     => 'El campo de :attribute es obligatorio cuando no hay :values.',
    'required_without_all' => 'El campo de :attribute es obligatorio cuando no hay :values.',
    'same'                 => ':attribute y :other deben coincidir.',
    'size'                 => [
        'numeric' => ':attribute debe ser :size.',
        'file'    => ':attribute debe ser :size kilobytes.',
        'string'  => ':attribute debe ser :size caracteres.',
        'array'   => ':attribute debe tener :size objetos.',
    ],
    'string'   => ':attribute debe estar compuesto de caracteres.',
    'timezone' => ':attribute debe ser una zona horaria válida.',
    'unique'   => ':attribute ya está registrado.',
    'uploaded' => 'Se ha producido un error al cargar :attribute.',
    'url'      => 'El formato de :attribute no es válido.',


    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes' => [
        'name' => 'Nombre Apellido',
        'email' => 'E-mail',
        'password' => 'Contraseña',
    ],

];
