<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'   => ':attribute must be accepted.',
    'active_url' => ':attribute must be a valid URL.',
    'after'      => ':attribute value must be a date later than :date .',
    'after_or_equal' => ':attribute value must be the subsequent or the same date as the :date',
    'alpha'      => ':attribute must only contain letters.',
    'alpha_dash' => ':attribute must only contain letters, numbers, and dashes',
    'alpha_num'  => ':attribute must contain only letters and numbers.',
    'array'      => ':attribute must be a sequence.',
    'before'     => ':attribute value must be a date earlier than :date.',
    'before_or_equal' => ':attribute value must be the same as the :date date or earlier.',
    'between'    => [
        'numeric' => ':attribute must be between :min - :max.',
        'file'    => ':attribute must have a value of kilobytes between   :min - :max.',
        'string'  => ':attribute must consist of :min -:max characters',
        'array'   => ':attribute must have the object between :min -:max.',
    ],
    'boolean'        => ':attribute field can only be true or false.',
    'confirmed'      => ':attribute repetition does not match.',
    'date'           => ':attribute must be a valid date.',
    'date_format'    => ': attribute does not match :format format.',
    'different'      => ':attribute and :other must be different from each other.',
    'digits'         => ': attribute must be  :digits digits.',
    'digits_between' => ':attribute must be the number between :min and :max.',
    'dimensions'     => ':attribute has invalid image dimensions.',
    'distinct'       => ':attribute field has a repeated value.',
    'email'          => ':attribute must be a correct e-mail.',
    'exists'         => 'Selected :attribute is invalid.',
    'file'           => ':attribute must be file.',
    'filled'         => ':attribute field must contain a value.',
    'image'          => ':attribute must be image file.',
    'in'             => ':attribute value is invalid.',
    'in_array'       => ':attribute value not available in :other.',
    'integer'        => ':attribute must be the number.',
    'ip'             => ':attribute must have a valid IP address.',
    'ipv4'           => ':attribute must have a valid IPv4 address.',
    'ipv6'           => ':attribute must be a valid IPv6 address.',
    'json'           => ':attribute must be a valid JSON string.',
    'max'            => [
        'numeric' => ':attribute value should not be greater than :max',
        'file'    => ':attribute value should not be greater than :max kilobyte value',
        'string'  => ':attribute value must be maximum :max characters long.',
        'array'   => ':attribute value should not have more than :max objects.',
    ],
    'mimes' => ':attribute file format must be :values.',
    'mimetypes'  => ':attribute file format must be :values.',
    'min'   => [
        'numeric' => ':attribute value must be at least :min value.',
        'file'    => ':attribute value must be at least in :min kilobytes value.',
        'string'  => ':attribute value must be at least :min characters long.',
        'array'   => ':attribute must have at least : min object.',
    ],
    'not_in'               => 'Selected :attribute is invalid.',
    'numeric'              => ':attribute must be the number.',
    'present'              => ':attribute field must exist.',
    'regex'                => ':attribute format is invalid.',
    'required'             => ':attribute field required.',
    'required_if'          => ':attribute field is mandatory when :other have :value.',
    'required_unless'      => ':attribute field is mandatory when :other has no :values .',
    'required_with'        => ':attribute field is mandatory when there are :values.',
    'required_with_all'    => ':attribute field is mandatory when there are :values.',
    'required_without'     => ':attribute field is mandatory when no :values.',
    'required_without_all' => ':attribute field is mandatory when no :values.',
    'same'                 => ':attribute must match with :other .',
    'size'                 => [
        'numeric' => ': attribute should be :size.',
        'file'    => ': attribute should be :size kilobytes.',
        'string'  => ':attribute must be :size characters.',
        'array'   => ':attribute must have :size objects.',
    ],
    'string'   => ':attribute  must be composed of characters.',
    'timezone' => ':attribute must be a valid time zone.',
    'unique'   => ':attribute has already been registered.',
    'uploaded' => 'Error while loading :attribute.',
    'url'      => ':attribute format is invalid.',


    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes' => [
        'name' => 'Name Surname',
        'email' => 'E-mail',
        'password' => 'Password',
    ],

];
