$(document).ready(function () {
    // Preloader
    $(".splash-screen").fadeOut();

    // Content padding
    $(".content").css("padding-top", $(".mobile-header").outerHeight());

    // Mobil Menü
    $(".m-toggle").click(function (e) {
        e.preventDefault();
        $(".main-nav").css("left", "0%");
        $(".overlay").fadeIn();
    });

    $(".close-nav, .overlay").click(function (e) {
        e.preventDefault();
        $(".main-nav").css("left", "-90%");
        $(".overlay").fadeOut();
    });

    // Menü
    $(".dropdown-nav a").click(function (e) {
        e.preventDefault();
        $(this).next("ul").slideToggle(150);

        if ($(this).attr("aria-expanded") == "true") {
            $(this).attr("aria-expanded", "false");
        } else if ($(this).attr("aria-expanded") == "false") {
            $(this).attr("aria-expanded", "true");
        }
    });

    // Menü Sekmeler
    $(".tab-nav a").click(function (e) {
        e.preventDefault();

        $(".tab-nav a").removeClass("active");
        $(this).addClass("active");

        var activeTab = $(this).data("tab");
        $('.tab-content .tab').removeClass("active");
        $('.tab-content .tab[data-tab="' + activeTab + '"]').addClass("active");
    });

    // Pencere hareketleri
   $(window).scroll(function () {
        var btn = $('.back-to-top');

        if ($(this).scrollTop() > 300) {
            btn.fadeIn();
        } else if ($(this).scrollTop() < 300) {
            btn.fadeOut()
        }

        btn.on('click', function (e) {
            e.preventDefault();
            $('html, body').animate({scrollTop: 0}, '300');
        });
    });

    // Arama
    var searchTrigger = $(".search-trigger");
    var searchContainer = $(".header-search");
    var searchBox = $(".header-search-box");

    searchTrigger.click(function (e) {
        e.preventDefault();

        searchContainer.slideToggle(100);
        searchBox.focus();
    });

    // Kategoriler
    $(".categories-trigger").click(function (e) {
        e.preventDefault();
        $(this).next(".categories-menu ul").slideToggle(100);

        if ($(this).attr('aria-expanded') === 'true') {
            $(this).attr('aria-expanded', 'false');
        } else {
            $(this).attr('aria-expanded', 'true');
        }
    })

    // Telif hakkı yıl
    var curYear = new Date().getFullYear().toString();
    $(".footer-copyright .year").text(curYear);

    // Animasyonlu kaydırma
    $('a[href*="#"]')
    .not('[href="#"]')
    .not('[href="#0"]')
    .click(function (event) {
        if (
            location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '')
            &&
            location.hostname == this.hostname
        ) {
            var target = $(this.hash);
            target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
            if (target.length) {
                event.preventDefault();
                $('html, body').animate({
                    scrollTop: target.offset().top -70
                }, 1000, function () {
                    var $target = $(target);
                    $target.focus();
                    if ($target.is(":focus")) {
                        return false;
                    } else {
                        $target.attr('tabindex', '-1');
                        $target.focus();
                    }
                    ;
                });
            }
        }
    });
});

$(window).on('load', function () {
    var imageHeight = $(".desktop-slider img").height();
    $(".categories-menu ul").height(imageHeight - 10);
});