<?php

use Illuminate\Database\Seeder;
use App\Models\SiteSetting;

class SiteSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        SiteSetting::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        $data = '[
  {
    "id": 1,
    "type": "genel",
    "option": "Site Başlığı",
    "entry": "site_title",
    "value": "Op. Dr. Muzaffer Al - Laparoskopik Bariatrik ve Metabolik Cerrah",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  
   {
    "id": 1,
    "type": "title",
    "option": "Blog Title",
    "entry": "blog_title",
    "value": "Op. Dr. Muzaffer Al - Laparoskopik Bariatrik ve Metabolik Cerrah",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
    {
    "id": 1,
    "type": "description",
    "option": "Blog Meta Description",
    "entry": "blog_description",
    "value": "Op. Dr. Muzaffer Al - Laparoskopik Bariatrik ve Metabolik Cerrah",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  
    {
    "id": 1,
    "type": "title",
    "option": "İletişim Meta Title",
    "entry": "contact_title",
    "value": "Op. Dr. Muzaffer Al - Laparoskopik Bariatrik ve Metabolik Cerrah",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
     {
    "id": 1,
    "type": "description",
    "option": "İletişim Meta Description",
    "entry": "contact_description",
    "value": "Op. Dr. Muzaffer Al - Laparoskopik Bariatrik ve Metabolik Cerrah",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 2,
    "type": "genel",
    "option": "Site Açıklaması",
    "entry": "site_description",
    "value": "Op. Dr. Muzaffer Al - Laparoskopik Bariatrik ve Metabolik Cerrah",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 3,
    "type": "genel",
    "option": "Bulunulan İl",
    "entry": "site_city",
    "value": "Samsun",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 4,
    "type": "genel",
    "option": "İletişim Telefon",
    "entry": "iletisim_tel",
    "value": "0 850 425 24 24",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 5,
    "type": "genel",
    "option": "İletişim GSM",
    "entry": "iletisim_gsm",
    "value": "0 850 425 24 24",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
    {
    "id": 5,
    "type": "genel",
    "option": "Site Whatsapp ",
    "entry": "site_wp",
    "value": "0905455381234",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 6,
    "type": "genel",
    "option": "İletişim Mail",
    "entry": "iletisim_mail",
    "value": "info@adtorium.com",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 7,
    "type": "genel",
    "option": "İletişim Adres",
    "entry": "iletisim_adres",
    "value": "Cumhuriyet Mahallesi İsmet İnönü Bulvarı No:293 Atakum / SAMSUN",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 8,
    "type": "genel",
    "option": "Site Geçerli Teması",
    "entry": "themes_dir",
    "value": "muzaff",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 9,
    "type": "image",
    "option": "Logo",
    "entry": "site_logo",
    "value": "/uploads/site/logo.png",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-04-28 09:54:11"
  },
  {
    "id": 10,
    "type": "image",
    "option": "Favicon Png",
    "entry": "favicon_png",
    "value": "/uploads/site/favicon.png",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-04-28 11:05:04"
  },
  {
    "id": 11,
    "type": "image",
    "option": "Favicon Ico",
    "entry": "favicon_ico",
    "value": "/uploads/site/favicon.ico",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-04-28 11:05:04"
  },
  {
    "id": 12,
    "type": "social",
    "option": "Facebook Adresi",
    "entry": "facebook_adres",
    "value": "#",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 13,
    "type": "social",
    "option": "Twitter Adresi",
    "entry": "twitter_adres",
    "value": "#",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 14,
    "type": "social",
    "option": "Instagram Adresi",
    "entry": "instagram_adres",
    "value": "#",
    "serialized": null,
    "created_at": "2018-04-19 19:33:39",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 15,
    "type": "social",
    "option": "Google+ Adresi",
    "entry": "google_adres",
    "value": "#",
    "serialized": null,
    "created_at": "2018-04-19 19:33:40",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 16,
    "type": "social",
    "option": "Pinterest Adresi",
    "entry": "pinterest_adres",
    "value": "#",
    "serialized": null,
    "created_at": "2018-04-19 19:33:40",
    "updated_at": "2018-05-01 15:08:29"
  },
  {
    "id": 17,
    "type": "social",
    "option": "LinkedIn Adresi",
    "entry": "linkedin_adres",
    "value": "#",
    "serialized": null,
    "created_at": "2018-04-19 19:33:40",
    "updated_at": "2018-05-01 15:08:29"
  }
 
]';
        $veri = json_decode($data);
        foreach ($veri as $item) {
            DB::table('site_settings')->insert([
                'type' => $item->type,
                'option' => $item->option,
                'entry' => $item->entry,
                'value' => $item->value,
                'serialized' => $item->serialized
            ]);
        }
    }
}
