<?php

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\MyModel;
use App\Models\Role;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Permission::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        $roles = Role::all();
        $models = MyModel::all();
        foreach($roles as $role)
        {
            foreach($models as $model)
            {
                if($role->name == 'admin')
                {
                    $create = 1;
                    $update = 1;
                    $delete = 1;
                } else if ($role->name == 'demo'){
                    $create = 0;
                    $update = 0;
                    $delete = 0;
                } else {
                    if($model->model == 'Article' || $model->model == 'Blog' || $model->model == 'Page')
                    {
                        $create = 1;
                        $update = 1;
                        $delete = 1;
                    } else {
                        $create = 0;
                        $update = 0;
                        $delete = 0;
                    }
                }
                DB::table('permissions')->insert([
                    'role_id' => $role->id,
                    'model_id' => $model->model_id,
                    'create' => $create,
                    'update' => $update,
                    'read' => 1,
                    'delete' => $delete,
                ]);
            }
        }
    }
}
