<?php

use Illuminate\Database\Seeder;
use App\Models\MyModel;

class ModelTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        MyModel::truncate();

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $dir = app_path('Models/');

        if (is_dir($dir)){
            if ($dh = opendir($dir)){
                while (($file = readdir($dh)) !== false){
                    if($file == "." || $file == ".."){
                        continue;
                    }

                    $fileArray = explode(".",$file);

                    DB::table('models')->insert([
                        'model'         => $fileArray[0],
                        'model_desc'    => $fileArray[0] . " Management"
                    ]);
                }
                closedir($dh);
            }
        }
    }
}
