<?php

use Illuminate\Database\Seeder;

use App\Models\Language;

class LanguageTableSeeder extends Seeder
{
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Language::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        DB::table('languages')->insert([
            'language_short_name' => 'tr',
            'language_details' => 'Türkçe',
            'language_image' => '/uploads/site/tr_flag.png',
            'language_default' => 1,
        ]);

        DB::table('languages')->insert([
            'language_short_name' => 'en',
            'language_details' => 'İngilizce',
            'language_image' => '/uploads/site/en_flag.png',
            'language_default' => 0,
        ]);
    }
}
