<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePatientOperationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('patient_operations', function (Blueprint $table) {
            $table->increments('pao_id');
            $table->integer('patient_id')->unsigned();
            $table->string('subject', 200);
            $table->string('steps', 200);
            $table->string('operator', 200);
            $table->double('price', [7, 2]);
            $table->string('current',200);
            $table->string('operation_date',200);
            $table->text('note');
            $table->timestamps();
            $table->foreign('patient_id')->references('patient_id')->on('patients')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('patient_operations');
    }
}
