<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->increments('payment_id');
            $table->string('order_id')->nullable();;
            $table->string('ccm_number')->nullable();
            $table->string('name');
            $table->string('phone');
            $table->text('note')->nullable();
            $table->string('currency');
            $table->string('amount');
            $table->string('transaction_id')->nullable();
            $table->string('bank')->nullable();
            $table->boolean('status')->default(0);
            $table->text('bank_response');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
