<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaticMetaDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('static_meta_details', function (Blueprint $table) {
            $table->increments('meta_details_id');
            $table->unsignedInteger('meta_id');
            $table->unsignedInteger('language_id');
            $table->string('meta_title');
            $table->string('meta_description');

            $table->foreign('meta_id')->references('meta_id')->on('static_metas')->onDelete('cascade');
            $table->foreign('language_id')->references('language_id')->on('languages')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('static_meta_details');
    }
}
