<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMedicalStaffDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('medical_staff_details', function (Blueprint $table) {
            $table->increments('medical_staff_details_id');
            $table->integer('medical_staff_id')->unsigned();
            $table->unsignedInteger('language_id');
            $table->string('position', 100);

            $table->foreign('medical_staff_id')->references('medical_staff_id')->on('medical_staffs')->onDelete("cascade");
            $table->foreign('language_id')->references('language_id')->on('languages')->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('medical_staff_details');
    }
}
