<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePhotoDetailTable extends Migration
{
    public function up()
    {
        Schema::create('photo_details', function (Blueprint $table) {
            $table->increments('photo_detail_id');
            $table->unsignedInteger('photo_id');
            $table->unsignedInteger('photo_gallery_id');
            $table->unsignedInteger('language_id')->nullable();
            $table->string('photo_name');
            $table->string('photo_image')->nullable();
            $table->string('photo_description');
            $table->integer('rank')->nullable();
            $table->boolean('status')->default(0);
            $table->boolean('in_gallery')->default(0);
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->foreign('photo_id')->references('photo_id')->on('photos')->onDelete('cascade');
            $table->foreign('language_id')->references('language_id')->on('languages')->onDelete('cascade');

        });
    }

    public function down()
    {
        Schema::dropIfExists('photo_details');
    }
}