<?php
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
class CreatePhotoGalleryDetailsTable extends Migration
{

    public function up()
    {
        Schema::create('photo_gallery_details', function (Blueprint $table) {
            $table->increments('photo_gallery_detail_id');
            $table->unsignedInteger('photo_gallery_id');
            $table->unsignedInteger('language_id');
            $table->string('gallery_name');
            $table->string('meta_title')->nullable();
            $table->string('meta_description')->nullable();
            $table->string('image')->nullable();
            $table->string('alt_and_title')->nullable();
            $table->boolean('in_gallery')->default(0);
            $table->boolean('status')->default(0);
            $table->integer('rank')->nullable();
            $table->string('slug');
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));

            $table->foreign('language_id')->references('language_id')->on('languages')->onDelete('cascade');
            $table->foreign('photo_gallery_id')->references('photo_gallery_id')->on('photo_galleries')->onDelete('cascade');

        });
    }

    public function down()
    {
        Schema::dropIfExists('photo_gallery_details');
    }
}