<?php
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSliderDetailTable extends Migration
{
    public function up()
    {
        Schema::create('slider_details', function (Blueprint $table) {
            $table->increments('slider_detail_id');
            $table->unsignedInteger('slider_id');
            $table->unsignedInteger('language_id');
            $table->text('image')->nullable();
            $table->text('mobil_image')->nullable();
            $table->string('title', 255)->nullable();
            $table->string('text', 255)->nullable();
            $table->string('url', 255)->nullable();
            $table->integer('rank')->default(0);
            $table->boolean('slider_status')->default(1);
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP'));

            $table->foreign('language_id')->references('language_id')->on('languages');
            $table->foreign('slider_id')->references('slider_id')->on('sliders');

        });
    }

    public function down()
    {
        Schema::dropIfExists('slider_details');
    }
}