<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVideoGalleriesDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('video_galleries_details', function (Blueprint $table) {
            $table->increments('video_details_id');
            $table->unsignedInteger('gallery_id');
            $table->unsignedInteger('video_id');
            $table->unsignedInteger('language_id');
            $table->string('slug');
            $table->string('video_name');
            $table->string('video_image');
            $table->string('video_path');
            $table->text('video_description')->nullable();
            $table->boolean('status')->default(1);
            $table->integer('rank')->default(1);
            $table->boolean('in_gallery')->default(1);

            $table->foreign('video_id')->references('video_id')->on('video_galleries')->onDelete('cascade');
            $table->foreign('gallery_id')->references('gallery_id')->on('video_gallery_categories_details')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('video_galleries_details');
    }
}
