<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVideoGalleryCategoriesDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('video_gallery_categories_details', function (Blueprint $table) {
            $table->increments('gallery_details_id');
            $table->unsignedInteger('gallery_id');
            $table->unsignedInteger('language_id');
            $table->string('slug');
            $table->string('gallery_name');
            $table->string('meta_title');
            $table->string('meta_description');
            $table->string('image')->nullable();
            $table->string('alt_and_title')->nullable();
            $table->boolean('status');
            $table->boolean('in_gallery')->default(1);

            $table->foreign('gallery_id')->references('gallery_id')->on('video_gallery_categories')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('video_gallery_categories_details');
    }
}
