<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSssDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sss_details', function (Blueprint $table) {
            $table->increments('sss_details_id');
            $table->unsignedInteger('sss_id');
            $table->unsignedInteger('language_id');
            $table->text('question');
            $table->text('answer');

            $table->foreign('sss_id')->references('sss_id')->on('ssses')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sss_details');
    }
}
