<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCategoryDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('category_details', function (Blueprint $table) {
            $table->increments('category_details_id');
            $table->integer('category_id')->unsigned();
            $table->tinyInteger('language_id');
            $table->string('category_name', 100);
            $table->string('slug', 100);
            $table->string('category_meta_title', 150);
            $table->string('category_meta_description', 200);

            $table->foreign('category_id')->references('category_id')->on('categories')->onDelete('cascade');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('category_details');
    }
}
