<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMedicalStaffsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('medical_staffs', function (Blueprint $table) {
            $table->increments('medical_staff_id');
            $table->enum('type', ['doctor', 'other']);
            $table->string('name', 50);
            $table->string('surname', 50);
            $table->text('image');
            $table->integer('rank');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('medical_staffs');
    }
}
