<?php
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
class CreateRandevusTable extends Migration
{
    public function up()
    {
        Schema::create('randevular', function (Blueprint $table) {
            $table->increments('randevu_id');
            $table->string('adsoyad', 100);
            $table->string('telefon', 30);
            $table->timestamp('randevu_tarihi');
            $table->unsignedInteger('subject_id');
            $table->boolean('status')->default(0);
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));
            $table->foreign('subject_id')->references('subject_id')->on('appointment_subject_details');

        });

    }

    public function down()
    {
        Schema::dropIfExists('randevular');
    }
}