<?php
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
class CreateMenuDetailsTable extends Migration
{
    public function up()
    {
        Schema::create('menu_details', function (Blueprint $table) {
            $table->increments('menu_detail_id');
            $table->integer('menu_id')->unsigned();
            $table->integer('parent_id')->default(0);
            $table->string('link', 255)->default('#');
            $table->string('menu', 255)->nullable();
            $table->enum('type', ['normal', 'mega'])->default('normal');
            $table->integer('sira')->default(0);
            $table->string('target', 10)->default('_self');
            $table->string('css', 100)->nullable();
            $table->string('icon', 100)->nullable();
            $table->string('resim', 100)->nullable();
            $table->unsignedInteger('language_id');
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));
            $table->foreign('menu_id')->references('menu_id')->on('menus')->onDelete('cascade');
            $table->foreign('language_id')->references('language_id')->on('languages')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('menu_details', function (Blueprint $table) {

        });
    }
}
