<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePageDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('page_details', function (Blueprint $table) {
            $table->increments('page_details_id');
            $table->integer('page_id')->unsigned();
            $table->integer('language_id')->unsigned();
            $table->string('page_title',150);
            $table->text('page_content')->nullable();
            $table->string('slug',150)->nullable();
            $table->boolean('status')->default(0);
            $table->integer('rank');
            $table->string('page_meta_title',100)->nullable();
            $table->string('page_meta_description',255)->nullable();
            $table->text('page_meta_keywords')->nullable();
            $table->boolean('footer_status')->default(0);

            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));

            $table->foreign('page_id')->references('page_id')->on('pages')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('page_details');
    }
}
