<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBlogDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blog_details', function (Blueprint $table) {
            $table->increments('blog_details_id');
            $table->integer('blog_id')->unsigned();
            $table->unsignedInteger('language_id');
            $table->string('blog_title',150);
            $table->text('blog_content')->nullable();
            $table->string('slug',150);
            $table->boolean('status')->default(0);
            $table->integer('rank')->nullable();
            $table->string('blog_meta_title',100);
            $table->string('blog_meta_description',255);
            $table->text('blog_meta_keywords')->nullable();
            $table->string('image',255)->nullable();
            $table->string('alt_and_title',255)->nullable();
            $table->integer('views')->default(0);
            $table->boolean('footer_status')->default(0);
            $table->boolean('information_status')->default(0);

            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));

            $table->foreign('blog_id')->references('blog_id')->on('blogs')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blog_details');
    }
}
