<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateArticleDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_details', function (Blueprint $table) {
            $table->increments('article_details_id');
            $table->integer('article_id')->unsigned();
            $table->tinyInteger('language_id');
            $table->string('article_title',150)->nullable();
            $table->text('article_content')->nullable();
            $table->string('slug',150);
            $table->integer('category_id')->unsigned();
            $table->boolean('status')->default(0);
            $table->integer('rank')->default(1)->nullable();
            $table->string('article_meta_title',100);
            $table->string('article_meta_description',255);
            $table->text('article_meta_keywords')->nullable();
            $table->string('image',255)->nullable();
            $table->string('alt_and_title',255)->nullable();
            $table->string('article_video',255)->nullable();
            $table->integer('views')->default(0);
            $table->boolean('information_status')->default(0);

            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));

            $table->foreign('article_id')->references('article_id')->on('articles')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blog_details');
    }
}
