<?php
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
class CreateAppointmentSubjectDetailTable extends Migration
{
    public function up()
    {
        Schema::create('appointment_subject_details', function (Blueprint $table) {
            $table->increments('subject_detail_id');
            $table->string('name')->nullable();
            $table->boolean('status')->defualt(0);
            $table->integer('rank')->nullable();
            $table->unsignedInteger('subject_id');
            $table->unsignedInteger('language_id');
            $table->foreign('subject_id')->references('subject_id')->on('appointment_subjects')->onDelete('cascade');
            $table->foreign('language_id')->references('language_id')->on('languages')->onDelete('cascade');
            $table->timestamp('created_at')->defualt(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->defualt(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
        });
    }

    public function down()
    {
        Schema::dropIfExists('appointment_subject_details');
    }
}